/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;

public final class ConfigurationHelper {
    public static int numLocalModeMaps = 1;

    public static void setJobNumMaps(Job job, int numMapTasks) {
        if (ConfigurationHelper.isLocalJobTracker(job.getConfiguration())) {
            numLocalModeMaps = numMapTasks;
        } else {
            job.getConfiguration().setInt("mapred.map.tasks", numMapTasks);
        }
    }

    public static int getJobNumMaps(JobContext job) {
        if (ConfigurationHelper.isLocalJobTracker(job.getConfiguration())) {
            return numLocalModeMaps;
        }
        return job.getConfiguration().getInt("mapred.map.tasks", 1);
    }

    public static long getNumMapOutputRecords(Job job) throws IOException, InterruptedException {
        return job.getCounters().findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_OUTPUT_RECORDS").getValue();
    }

    public static long getNumMapInputRecords(Job job) throws IOException, InterruptedException {
        return job.getCounters().findCounter("org.apache.hadoop.mapred.Task$Counter", "MAP_INPUT_RECORDS").getValue();
    }

    public static int getConfNumMaps(Configuration conf) {
        if (ConfigurationHelper.isLocalJobTracker(conf)) {
            return numLocalModeMaps;
        }
        return conf.getInt("mapred.map.tasks", 1);
    }

    public static void setJobMapSpeculativeExecution(Job job, boolean isEnabled) {
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", isEnabled);
    }

    public static void setJobReduceSpeculativeExecution(Job job, boolean isEnabled) {
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", isEnabled);
    }

    public static String getDbInputClassProperty() {
        return "mapreduce.jdbc.input.class";
    }

    public static String getDbUsernameProperty() {
        return "mapreduce.jdbc.username";
    }

    public static String getDbPasswordProperty() {
        return "mapreduce.jdbc.password";
    }

    public static String getDbUrlProperty() {
        return "mapreduce.jdbc.url";
    }

    public static String getDbInputTableNameProperty() {
        return "mapreduce.jdbc.input.table.name";
    }

    public static String getDbInputConditionsProperty() {
        return "mapreduce.jdbc.input.conditions";
    }

    public static String[] parseGenericOptions(Configuration conf, String[] args) throws IOException {
        GenericOptionsParser genericParser = new GenericOptionsParser(conf, args);
        return genericParser.getRemainingArgs();
    }

    public static <U> List<U> getInstances(Configuration conf, String name, Class<U> xface) {
        Class[] classes;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Class cl : classes = conf.getClasses(name, new Class[0])) {
            if (!xface.isAssignableFrom(cl)) {
                throw new RuntimeException(cl + " does not implement " + xface);
            }
            ret.add(ReflectionUtils.newInstance((Class)cl, (Configuration)conf));
        }
        return ret;
    }

    public static void setSplitLimit(Configuration config, long splitLimit) {
        config.setLong("split.limit", splitLimit);
    }

    public static long getSplitLimit(Configuration config) {
        return config.getInt("split.limit", -1);
    }

    public static boolean isLocalJobTracker(Configuration conf) {
        String frameworkName = conf.get("mapreduce.framework.name");
        return "local".equals(frameworkName);
    }

    private ConfigurationHelper() {
    }

    public static Integer getIntegerConfigIfExists(Configuration conf, String key) {
        Integer config = null;
        String configString = conf.get(key, null);
        if (configString != null) {
            config = Integer.valueOf(configString);
        }
        return config;
    }
}

