/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.authentication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class KerberosAuthenticator {
    private final Configuration configuration;
    private final String principal;
    private final String keytabLocation;

    public KerberosAuthenticator(Configuration configuration, String principal, String keytabLocation) {
        this.configuration = configuration;
        this.principal = principal;
        this.keytabLocation = keytabLocation;
    }

    public UserGroupInformation authenticate() {
        UserGroupInformation.setConfiguration((Configuration)this.configuration);
        try {
            return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytabLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Kerberos authentication failed!", e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getKeytabLocation() {
        return this.keytabLocation;
    }
}

