/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.ValidatingPropertyEditorComponent;

public class CustomPropertyEditorDialog
extends CommonDialog {
    private ValidatingPropertyEditorComponent validatingView;
    private ValidationHandler validationHandler;
    private JPanel contentPane;

    public CustomPropertyEditorDialog() throws HeadlessException {
        this.setModal(true);
        this.init();
    }

    public CustomPropertyEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public CustomPropertyEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    @Override
    protected void init() {
        this.validationHandler = new ValidationHandler();
        this.contentPane = new JPanel(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getInstance().getString("CustomPropertyEditorDialog.Title"));
        this.setPreferredSize(new Dimension(500, 550));
        super.init();
    }

    @Override
    protected String getDialogId() {
        return "LibSwing.CustomPropertyEditor";
    }

    @Override
    protected Component createContentPane() {
        return this.contentPane;
    }

    public boolean performEdit(PropertyEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        Object originalValue = editor.getValue();
        Component view = editor.getCustomEditor();
        if (view instanceof ValidatingPropertyEditorComponent) {
            this.validatingView = (ValidatingPropertyEditorComponent)((Object)view);
            this.validatingView.addPropertyChangeListener(this.validationHandler);
        } else {
            this.validatingView = null;
        }
        this.contentPane.removeAll();
        this.contentPane.add((Component)new JScrollPane(view), "Center");
        if (!super.performEdit()) {
            try {
                editor.setValue(originalValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.validatingView != null) {
            this.validatingView.removePropertyChangeListener(this.validationHandler);
        }
        return this.isConfirmed();
    }

    private class ValidationHandler
    implements PropertyChangeListener {
        private ValidationHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (CustomPropertyEditorDialog.this.validatingView == null) {
                return;
            }
            CustomPropertyEditorDialog.this.getConfirmAction().setEnabled(CustomPropertyEditorDialog.this.validatingView.isValidEditorValue());
        }
    }
}

