/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.designtime.swing.background.ProgressFeed;
import org.pentaho.reporting.libraries.designtime.swing.background.WaitDialog;

public class WaitDialogMonitorThread
extends Thread {
    private static final Log log = LogFactory.getLog(WaitDialogMonitorThread.class);
    private final WaitDialog waitDialog;
    private ProgressFeed progressFeed;
    private final Thread workerThread;
    private double progress;

    public WaitDialogMonitorThread(Thread workerThread, WaitDialog waitDialog, ProgressFeed progressFeed) {
        this.workerThread = workerThread;
        this.waitDialog = waitDialog;
        this.progressFeed = progressFeed;
        this.progress = -1.0;
    }

    @Override
    public void run() {
        try {
            log.debug((Object)"Waiting for worker thread to complete");
            while (this.workerThread.isAlive()) {
                double p;
                if (this.progressFeed != null && (p = this.progressFeed.queryProgress()) != this.progress) {
                    this.waitDialog.updateProgress(p);
                    this.progress = p;
                }
                this.workerThread.join(500L);
            }
        }
        catch (Throwable t) {
            log.warn((Object)("The worker thread threw an exception: [" + t.getMessage() + "]"));
        }
        finally {
            log.debug((Object)"The worker thread has finished - telling the dialog to close");
            this.waitDialog.exit();
        }
    }
}

