/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoverableWrapper;
import org.apache.twill.discovery.ServiceDiscovered;

final class DefaultServiceDiscovered
implements ServiceDiscovered {
    private final String name;
    private final AtomicReference<Set<Discoverable>> discoverables;
    private final List<ListenerCaller> listenerCallers;
    private final ReadWriteLock callerLock;

    DefaultServiceDiscovered(String name) {
        this.name = name;
        this.discoverables = new AtomicReference<ImmutableSet>(ImmutableSet.of());
        this.listenerCallers = Lists.newLinkedList();
        this.callerLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDiscoverables(Set<Discoverable> discoverables) {
        this.discoverables.set((Set<Discoverable>)ImmutableSet.copyOf(discoverables));
        ArrayList callers = Lists.newArrayList();
        Lock readLock = this.callerLock.readLock();
        readLock.lock();
        try {
            callers.addAll(this.listenerCallers);
        }
        finally {
            readLock.unlock();
        }
        for (ListenerCaller caller : callers) {
            caller.invoke();
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable watchChanges(ServiceDiscovered.ChangeListener listener, Executor executor) {
        ListenerCaller caller = new ListenerCaller(listener, executor);
        Lock writeLock = this.callerLock.writeLock();
        writeLock.lock();
        try {
            this.listenerCallers.add(caller);
        }
        finally {
            writeLock.unlock();
        }
        caller.invoke();
        return caller;
    }

    public boolean contains(Discoverable discoverable) {
        if (!discoverable.getName().equals(this.name)) {
            return false;
        }
        Discoverable target = discoverable;
        if (!(target instanceof DiscoverableWrapper)) {
            target = new DiscoverableWrapper(target);
        }
        return this.discoverables.get().contains(target);
    }

    public Iterator<Discoverable> iterator() {
        return this.discoverables.get().iterator();
    }

    private final class ListenerCaller
    implements Runnable,
    Cancellable {
        private final ServiceDiscovered.ChangeListener listener;
        private final Executor executor;
        private final AtomicBoolean cancelled;

        private ListenerCaller(ServiceDiscovered.ChangeListener listener, Executor executor) {
            this.listener = listener;
            this.executor = executor;
            this.cancelled = new AtomicBoolean(false);
        }

        void invoke() {
            if (!this.cancelled.get()) {
                this.executor.execute(this);
            }
        }

        @Override
        public void run() {
            if (!this.cancelled.get()) {
                this.listener.onChange((ServiceDiscovered)DefaultServiceDiscovered.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                Lock writeLock = DefaultServiceDiscovered.this.callerLock.writeLock();
                writeLock.lock();
                try {
                    DefaultServiceDiscovered.this.listenerCallers.remove(this);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }
}

