/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.wsdl.Part;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class Message
extends WsdlNode {
    private QName name;
    private ArrayList<Part> parts = new ArrayList();
    private String targetNamespace;

    Message(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public QName getName() {
        return this.name;
    }

    public Iterator<Part> getParts() {
        return this.parts.iterator();
    }

    public Part getPart(String part) throws ConnectionException {
        for (Part p : this.parts) {
            if (!part.equals(p.getName())) continue;
            return p;
        }
        throw new ConnectionException("Failed to find part " + part);
    }

    public void read(WsdlParser parser) throws WsdlParseException {
        this.name = new QName(this.targetNamespace, parser.getAttributeValue(null, "name"));
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if (n != null && ns != null) {
                    this.parse(n, ns, parser);
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("message".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace) && "part".equals(name)) {
            Part part = new Part();
            part.read(parser);
            this.parts.add(part);
        }
    }
}

