/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.wire.ParameterBufferBase;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;

class ServiceRequestBufferImp
extends ParameterBufferBase
implements ServiceRequestBuffer {
    private int taskIdentifier;

    ServiceRequestBufferImp(int taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    public int getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public void addArgument(int argumentType, String value) {
        this.getArgumentsList().add(new ParameterBufferBase.StringArgument(argumentType, value){

            int getLength() {
                return super.getLength() + 1;
            }

            protected void writeLength(int length, XdrOutputStream outputStream) throws IOException {
                outputStream.write(length);
                outputStream.write(length >> 8);
            }
        });
    }

    public void addArgument(int argumentType, int value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            int getLength() {
                return 5;
            }

            protected void writeValue(XdrOutputStream outputStream, int value) throws IOException {
                outputStream.write(value);
                outputStream.write(value >> 8);
                outputStream.write(value >> 16);
                outputStream.write(value >> 24);
            }
        });
    }

    public void addArgument(int argumentType, byte value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            protected void writeValue(XdrOutputStream outputStream, int value) throws IOException {
                outputStream.write((byte)value);
            }
        });
    }

    public void write(XdrOutputStream outputStream) throws IOException {
        outputStream.write(this.taskIdentifier);
        super.write(outputStream);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XdrOutputStream outputStream = new XdrOutputStream(out);
        this.write(outputStream);
        outputStream.flush();
        out.flush();
        return out.toByteArray();
    }
}

