/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.big.data.kettle.plugins.hbase.meta.AELHBaseValueMetaImpl;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class AELHBaseMappingImpl
implements Mapping,
Serializable {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private String mappingName;
    private String keyName;
    private Mapping.KeyType keyType;
    private String keyTypeAsString;
    private int numMappedColumns;
    private Map<String, HBaseValueMetaInterface> mappedColumns;

    public String addMappedColumn(HBaseValueMetaInterface hBaseValueMetaInterface, boolean b) throws Exception {
        if (this.mappedColumns == null) {
            this.mappedColumns = new HashMap<String, HBaseValueMetaInterface>();
        }
        this.mappedColumns.put(hBaseValueMetaInterface.getAlias(), hBaseValueMetaInterface);
        ++this.numMappedColumns;
        return hBaseValueMetaInterface.getAlias();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Mapping.KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Mapping.KeyType keyType) {
        this.keyType = keyType;
    }

    public Map<String, HBaseValueMetaInterface> getMappedColumns() {
        return this.mappedColumns;
    }

    public void setMappedColumns(Map<String, HBaseValueMetaInterface> mappedColumns) {
        this.mappedColumns = mappedColumns;
    }

    public void setKeyTypeAsString(String s) throws Exception {
        this.keyTypeAsString = s;
    }

    public boolean isTupleMapping() {
        return false;
    }

    public void setTupleMapping(boolean b) {
    }

    public String getTupleFamilies() {
        return null;
    }

    public String[] getTupleFamiliesSplit() {
        return new String[0];
    }

    public void setTupleFamilies(String s) {
    }

    public int numMappedColumns() {
        return this.numMappedColumns;
    }

    public void saveRep(Repository repository, ObjectId objectId, ObjectId objectId1) throws KettleException {
    }

    public String getXML() {
        if (Const.isEmpty((String)this.getKeyName())) {
            return "";
        }
        String retString = "";
        retString = retString + XMLHandler.openTag((String)"mapping");
        retString = retString + XMLHandler.addTagValue((String)"mapping_name", (String)this.getMappingName());
        retString = retString + XMLHandler.addTagValue((String)"table_name", (String)this.getTableName());
        retString = retString + XMLHandler.addTagValue((String)"key", (String)this.getKeyName());
        retString = retString + XMLHandler.addTagValue((String)"key_type", (String)this.getKeyType().toString());
        if (this.mappedColumns.size() > 0) {
            retString = retString + XMLHandler.openTag((String)"mapped_columns");
            for (String alias : this.mappedColumns.keySet()) {
                HBaseValueMetaInterface vm = this.mappedColumns.get(alias);
                retString = retString + XMLHandler.openTag((String)"mapped_column");
                retString = retString + XMLHandler.addTagValue((String)"alias", (String)alias);
                retString = retString + XMLHandler.addTagValue((String)"column_family", (String)vm.getColumnFamily());
                retString = retString + XMLHandler.addTagValue((String)"column_name", (String)vm.getColumnName());
                retString = retString + XMLHandler.addTagValue((String)"type", (String)vm.getHBaseTypeDesc());
                retString = retString + XMLHandler.closeTag((String)"mapped_column");
            }
            retString = retString + XMLHandler.closeTag((String)"mapped_columns");
        }
        retString = retString + XMLHandler.closeTag((String)"mapping");
        return retString;
    }

    public boolean loadXML(Node node) throws KettleXMLException {
        Node fields;
        if ((node = XMLHandler.getSubNode((Node)node, (String)"mapping")) == null || Const.isEmpty((String)XMLHandler.getTagValue((Node)node, (String)"key"))) {
            return false;
        }
        this.setMappingName(XMLHandler.getTagValue((Node)node, (String)"mapping_name"));
        this.setTableName(XMLHandler.getTagValue((Node)node, (String)"table_name"));
        String keyName = XMLHandler.getTagValue((Node)node, (String)"key");
        if (keyName.indexOf(44) > 0) {
            String familiesList;
            this.setTupleMapping(true);
            this.setKeyName(keyName.substring(0, keyName.indexOf(44)));
            if (keyName.indexOf(44) != keyName.length() - 1 && !Const.isEmpty((String)(familiesList = keyName.substring(keyName.indexOf(44) + 1, keyName.length())).trim())) {
                this.setTupleFamilies(familiesList);
            }
        } else {
            this.setKeyName(keyName);
        }
        String keyTypeS = XMLHandler.getTagValue((Node)node, (String)"key_type");
        for (Mapping.KeyType k : Mapping.KeyType.values()) {
            if (!k.toString().equalsIgnoreCase(keyTypeS)) continue;
            this.setKeyType(k);
            break;
        }
        if ((fields = XMLHandler.getSubNode((Node)node, (String)"mapped_columns")) != null && XMLHandler.countNodes((Node)fields, (String)"mapped_column") > 0) {
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"mapped_column");
            for (int i = 0; i < nrfields; ++i) {
                String colName;
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mapped_column", (int)i);
                String alias = XMLHandler.getTagValue((Node)fieldNode, (String)"alias");
                String colFam = XMLHandler.getTagValue((Node)fieldNode, (String)"column_family");
                if (colFam == null) {
                    colFam = "";
                }
                if ((colName = XMLHandler.getTagValue((Node)fieldNode, (String)"column_name")) == null) {
                    colName = "";
                }
                String type = XMLHandler.getTagValue((Node)fieldNode, (String)"type");
                AELHBaseValueMetaImpl vm = new AELHBaseValueMetaImpl(false, alias, colName, colFam, this.getMappingName(), this.getTableName());
                vm.setHBaseTypeFromString(type);
                try {
                    this.addMappedColumn(vm, this.isTupleMapping());
                    continue;
                }
                catch (Exception ex) {
                    throw new KettleXMLException((Throwable)ex);
                }
            }
        }
        return true;
    }

    public boolean readRep(Repository repository, ObjectId objectId) throws KettleException {
        return false;
    }

    public String getFriendlyName() {
        return null;
    }

    public Object decodeKeyValue(byte[] bytes) throws KettleException {
        return null;
    }
}

