/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.blueprint;

import java.net.URL;
import java.util.Set;
import java.util.UUID;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.pentaho.di.osgi.AnnotationBasedOsgiPlugin;
import org.pentaho.di.osgi.PdiPluginSupplementalClassMappings;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PentahoNamespaceHandler
implements NamespaceHandler {
    public static final String DI_PLUGIN = "di-plugin";
    public static final String DI_PLUGIN_EXTRA_MAPPINGS = "di-plugin-mappings";
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String AUTO_PDI_PLUGIN = "auto_pdi_plugin_";
    public static final String AUTO_DI_PLUGIN_MAPPINGS = "auto_di_plugin_mappings_";
    private BundleContext bundleContext;

    public PentahoNamespaceHandler(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public URL getSchemaLocation(String s) {
        return this.getClass().getResource("/pentaho-blueprint.xsd");
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public Metadata parse(Element element, ParserContext parserContext) {
        if (element.getNodeName() != null && element.getNodeName().endsWith(DI_PLUGIN_EXTRA_MAPPINGS)) {
            return this.processExtraMappings(element, parserContext);
        }
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        String nodeName = node.getNodeName();
        if (nodeName.contains(":")) {
            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
        }
        switch (nodeName) {
            case "di-plugin": {
                MutableBeanMetadata pluginBeanMetadata = this.createKettlePluginBean(node, componentMetadata, parserContext);
                MutableServiceMetadata serviceMetadata = this.createServiceMeta(componentMetadata, parserContext, pluginBeanMetadata);
                parserContext.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)pluginBeanMetadata);
                parserContext.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)serviceMetadata);
            }
        }
        return componentMetadata;
    }

    private MutableBeanMetadata processExtraMappings(Node node, ParserContext parserContext) {
        MutableBeanMetadata pluginBeanMetadata = this.createExtraMappingsBean(node, parserContext);
        String kettlePluginType = node.getAttributes().getNamedItem(TYPE).getTextContent();
        String pluginId = node.getAttributes().getNamedItem(ID).getTextContent();
        MutableServiceMetadata serviceMetadata = this.createServiceMeta((ComponentMetadata)pluginBeanMetadata, parserContext, pluginBeanMetadata);
        serviceMetadata.addServiceProperty((NonNullMetadata)this.createValue(parserContext, ID), (Metadata)this.createValue(parserContext, pluginId));
        MutableValueMetadata value = this.createValue(parserContext, kettlePluginType);
        value.setType(Class.class.getName());
        serviceMetadata.addServiceProperty((NonNullMetadata)this.createValue(parserContext, TYPE), (Metadata)value);
        parserContext.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)serviceMetadata);
        return pluginBeanMetadata;
    }

    private MutableValueMetadata createValue(ParserContext parserContext, String value) {
        MutableValueMetadata metadata = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
        metadata.setStringValue(value);
        return metadata;
    }

    private MutableServiceMetadata createServiceMeta(ComponentMetadata componentMetadata, ParserContext parserContext, MutableBeanMetadata pluginBeanMetadata) {
        MutableServiceMetadata serviceMetadata = (MutableServiceMetadata)parserContext.createMetadata(MutableServiceMetadata.class);
        MutableRefMetadata mutableRefMetadata = (MutableRefMetadata)parserContext.createMetadata(MutableRefMetadata.class);
        mutableRefMetadata.setComponentId(pluginBeanMetadata.getId());
        serviceMetadata.setServiceComponent((Target)mutableRefMetadata);
        serviceMetadata.setAutoExport(4);
        serviceMetadata.setId("auto_pdi_plugin_service_" + componentMetadata.getId());
        return serviceMetadata;
    }

    private MutableBeanMetadata createKettlePluginBean(Node node, ComponentMetadata componentMetadata, ParserContext parserContext) {
        String kettlePluginType = node.getAttributes().getNamedItem(TYPE).getTextContent();
        MutableBeanMetadata pluginBeanMetadata = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
        pluginBeanMetadata.setClassName(AnnotationBasedOsgiPlugin.class.getName());
        MutableValueMetadata kettlePluginTypeMeta = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
        kettlePluginTypeMeta.setStringValue(kettlePluginType);
        MutableRefMetadata beanReferenceMeta = (MutableRefMetadata)parserContext.createMetadata(MutableRefMetadata.class);
        beanReferenceMeta.setComponentId(componentMetadata.getId());
        MutableRefMetadata containerReferenceMeta = (MutableRefMetadata)parserContext.createMetadata(MutableRefMetadata.class);
        containerReferenceMeta.setComponentId("blueprintContainer");
        MutableValueMetadata beanNameMeta = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
        beanNameMeta.setStringValue(componentMetadata.getId());
        MutableMapMetadata classToBeanMap = this.createMapping(parserContext, node);
        pluginBeanMetadata.addArgument((Metadata)kettlePluginTypeMeta, null, 0);
        pluginBeanMetadata.addArgument((Metadata)beanReferenceMeta, null, 1);
        pluginBeanMetadata.addArgument((Metadata)beanNameMeta, null, 2);
        pluginBeanMetadata.addArgument((Metadata)classToBeanMap, null, 3);
        pluginBeanMetadata.addArgument((Metadata)containerReferenceMeta, null, 4);
        pluginBeanMetadata.setId(AUTO_PDI_PLUGIN + componentMetadata.getId());
        return pluginBeanMetadata;
    }

    private MutableBeanMetadata createExtraMappingsBean(Node node, ParserContext parserContext) {
        MutableBeanMetadata mappingBeanMeta = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
        mappingBeanMeta.setId(AUTO_DI_PLUGIN_MAPPINGS + UUID.randomUUID());
        mappingBeanMeta.setClassName(PdiPluginSupplementalClassMappings.class.getName());
        MutableRefMetadata containerReferenceMeta = (MutableRefMetadata)parserContext.createMetadata(MutableRefMetadata.class);
        containerReferenceMeta.setComponentId("blueprintContainer");
        MutableMapMetadata classToBeanMap = this.createMapping(parserContext, node);
        mappingBeanMeta.addArgument((Metadata)classToBeanMap, null, 0);
        mappingBeanMeta.addArgument((Metadata)containerReferenceMeta, null, 1);
        return mappingBeanMeta;
    }

    private MutableMapMetadata createMapping(ParserContext parserContext, Node node) {
        MutableMapMetadata classToBeanMap = (MutableMapMetadata)parserContext.createMetadata(MutableMapMetadata.class);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MutableValueMetadata prop = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
            NamedNodeMap attributes = nodeList.item(i).getAttributes();
            if (attributes == null) continue;
            Node classProp = nodeList.item(i).getAttributes().getNamedItem("class");
            Node refProp = nodeList.item(i).getAttributes().getNamedItem("ref");
            if (classProp == null || refProp == null) continue;
            prop.setStringValue(classProp.getNodeValue());
            prop.setType(Class.class.getName());
            MutableValueMetadata propVal = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
            propVal.setStringValue(refProp.getNodeValue());
            propVal.setType(String.class.getName());
            classToBeanMap.addEntry((NonNullMetadata)prop, (Metadata)propVal);
        }
        return classToBeanMap;
    }
}

