/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.pentaho.big.data.api.jdbc.DriverLocator;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseMetaWithVersion
extends BaseDatabaseMeta {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetaWithVersion.class);
    private final DriverLocator driverLocator;

    protected DatabaseMetaWithVersion(DriverLocator driverLocator) {
        this.driverLocator = driverLocator;
    }

    public abstract String getURL(String var1, String var2, String var3);

    protected boolean isDriverVersion(int majorVersion, int minorVersion) {
        int driverMinorVersion;
        int driverMajorVersion;
        if (this.getAccessType() == 4) {
            PooledDatasourceHelper pooledDatasourceHelper = new PooledDatasourceHelper();
            DataSource dataSource = null;
            try {
                dataSource = PooledDatasourceHelper.getJndiDataSource((String)this.getDatabaseName());
            }
            catch (DBDatasourceServiceException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            DatabaseMetaData meta = null;
            try (Connection connection = dataSource.getConnection();){
                meta = connection.getMetaData();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            driverMajorVersion = meta.getDriverMajorVersion();
            driverMinorVersion = meta.getDriverMinorVersion();
        } else {
            String url = this.getURL("localhost", "10000", "default");
            Driver driver = this.driverLocator.getDriver(url);
            driverMajorVersion = driver.getMajorVersion();
            driverMinorVersion = driver.getMinorVersion();
        }
        return driverMajorVersion > majorVersion || driverMajorVersion == majorVersion && driverMinorVersion >= minorVersion;
    }
}

