/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.pig;

import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.impl.shim.pig.PigServiceImpl;
import org.pentaho.bigdata.api.pig.PigService;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigServiceFactoryImpl
implements NamedClusterServiceFactory<PigService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PigServiceFactoryImpl.class);
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;

    public PigServiceFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public Class<PigService> getServiceClass() {
        return PigService.class;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        boolean ncState = namedCluster == null ? true : !namedCluster.isUseGateway();
        return this.isActiveConfiguration && ncState;
    }

    public PigService create(NamedCluster namedCluster) {
        try {
            PigShim pigShim = this.hadoopConfiguration.getPigShim();
            HadoopShim hadoopShim = this.hadoopConfiguration.getHadoopShim();
            return new PigServiceImpl(namedCluster, pigShim, hadoopShim);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Unable to create PigService for " + namedCluster, (Throwable)e);
            return null;
        }
    }
}

