/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.DefaultEditorKit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.SwingElement;
import org.pentaho.ui.xul.swing.SwingRoot;
import org.pentaho.ui.xul.swing.tags.SwingButton;
import org.pentaho.ui.xul.util.Orient;

public class SwingWindow
extends AbstractSwingContainer
implements XulWindow,
SwingRoot {
    private static final Log logger = LogFactory.getLog(SwingElement.class);
    JFrame frame;
    private int width;
    private int height;
    private XulDomContainer xulDomContainer;
    private String title = null;
    private String onload;
    private String onclose;
    private String onunload;
    private Clipboard clipboard;
    private String appicon = null;
    private XulDomContainer xulContainer;
    private Map<String, ButtonGroup> anonymousButtonGroups = new HashMap<String, ButtonGroup>();

    public SwingWindow(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("window");
        this.frame = new JFrame();
        this.xulDomContainer = domContainer;
        this.orientation = Orient.VERTICAL;
        this.xulContainer = domContainer;
        this.container = new JPanel(new GridBagLayout());
        this.setManagedObject(this.container);
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.resetContainer();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.container, "Center");
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingWindow.this.xulDomContainer.close();
            }
        });
        this.setManagedObject(this.frame);
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridy = -1;
        this.gc.gridx = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 0;
        this.gc.insets = new Insets(0, 0, 0, 0);
        this.gc.fill = 2;
        this.gc.anchor = 18;
        this.gc.weightx = 1.0;
    }

    public void setTitle(String title) {
        this.title = title;
        this.frame.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.frame.setSize(new Dimension(this.width, this.height));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.frame.setSize(new Dimension(this.width, this.height));
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.xulDomContainer = xulDomContainer;
    }

    public XulDomContainer getXulDomContainer() {
        return this.xulDomContainer;
    }

    public String getOnload() {
        return this.onload;
    }

    public void setOnload(String onload) {
        this.onload = onload;
    }

    public String getOnclose() {
        return this.onclose;
    }

    public String getOnunload() {
        return this.onunload;
    }

    public void setOnclose(String onclose) {
        this.onclose = onclose;
    }

    public void setOnunload(String onunload) {
        this.onunload = onunload;
    }

    @Override
    public void layout() {
        super.layout();
    }

    public void close() {
        this.frame.setVisible(false);
    }

    public boolean isClosed() {
        return !this.frame.isVisible();
    }

    public void open() {
        this.frame.setVisible(true);
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.resetContainer();
        super.replaceChild(oldElement, newElement);
    }

    public void copy() throws XulException {
        DefaultEditorKit.CopyAction act = new DefaultEditorKit.CopyAction();
        act.actionPerformed(new ActionEvent(this.getManagedObject(), 999, "copy"));
    }

    public void cut() {
        DefaultEditorKit.CutAction act = new DefaultEditorKit.CutAction();
        act.actionPerformed(new ActionEvent(this.getManagedObject(), 999, "cut"));
    }

    public void paste() {
        DefaultEditorKit.PasteAction act = new DefaultEditorKit.PasteAction();
        act.actionPerformed(new ActionEvent(this.getManagedObject(), 999, "paste"));
    }

    @Override
    public ButtonGroup getButtonGroup(String group) {
        if (this.anonymousButtonGroups.containsKey(group)) {
            return this.anonymousButtonGroups.get(group);
        }
        ButtonGroup grp = new ButtonGroup();
        this.anonymousButtonGroups.put(group, grp);
        return grp;
    }

    public void copy(String content) throws XulException {
        StringSelection data = new StringSelection(content);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
    }

    public Object getRootObject() {
        return this.frame;
    }

    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public void setAppicon(String icon) {
        try {
            this.appicon = icon;
            URL url = SwingButton.class.getClassLoader().getResource(this.xulContainer.getXulLoader().getRootDir() + icon);
            ImageIcon ico = new ImageIcon(url);
            if (ico.getImage() != null) {
                this.frame.setIconImage(ico.getImage());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error loading application icon: " + icon), (Throwable)e);
        }
    }
}

