/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.versionchecker.util;

import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.versionchecker.util.IVersionHelper;
import org.pentaho.versionchecker.util.ManifestUtil;
import org.pentaho.versionchecker.util.VersionInfo;

public final class VersionHelper
implements IVersionHelper {
    @Override
    public String getVersionInformation() {
        return this.getVersionInformation(VersionHelper.class);
    }

    @Override
    public String getVersionInformation(Class clazz) {
        String implTitle = clazz.getPackage().getImplementationTitle();
        String implVersion = clazz.getPackage().getImplementationVersion();
        if (implVersion != null) {
            return implTitle + " " + implVersion;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("version");
            StringBuffer buff = new StringBuffer();
            buff.append(bundle.getString("impl.title")).append(' ').append(bundle.getString("release.major.number")).append('.').append(bundle.getString("release.minor.number"));
            buff.append('.').append(bundle.getString("release.milestone.number")).append('.').append(bundle.getString("release.build.number")).append(" (class)");
            return buff.toString();
        }
        catch (Exception ex) {
            return "Pentaho BI Platform - No Version Information Available";
        }
    }

    public static VersionInfo getVersionInfo() {
        return VersionHelper.getVersionInfo(VersionHelper.class);
    }

    public static VersionInfo getVersionInfo(Class clazz) {
        Manifest manifest = ManifestUtil.getManifest(clazz);
        if (manifest != null) {
            return VersionHelper.createVersionInfo(manifest);
        }
        return VersionHelper.createVersionInfo();
    }

    protected static VersionInfo createVersionInfo(Manifest manifest) {
        VersionInfo versionInfo = new VersionInfo();
        Attributes mainAttributes = manifest.getMainAttributes();
        versionInfo.setFromManifest(true);
        versionInfo.setProductID(mainAttributes.getValue("Implementation-ProductID"));
        versionInfo.setTitle(mainAttributes.getValue("Implementation-Title"));
        versionInfo.setVersion(mainAttributes.getValue("Implementation-Version"));
        return versionInfo;
    }

    protected static VersionInfo createVersionInfo() {
        VersionInfo versionInfo = new VersionInfo();
        try {
            String[] parts;
            ResourceBundle bundle = ResourceBundle.getBundle("version");
            versionInfo.setFromManifest(false);
            versionInfo.setProductID(bundle.getString("impl.productID"));
            versionInfo.setTitle(bundle.getString("impl.title"));
            versionInfo.setVersionMajor(bundle.getString("release.major.number"));
            versionInfo.setVersionMinor(bundle.getString("release.minor.number"));
            versionInfo.setVersionBuild(bundle.getString("release.build.number"));
            String releaseMilestoneNumber = bundle.getString("release.milestone.number");
            if (releaseMilestoneNumber != null && (parts = releaseMilestoneNumber.replace('-', '.').split("\\.")).length > 0) {
                versionInfo.setVersionRelease(parts[0]);
                if (parts.length > 1) {
                    versionInfo.setVersionMilestone(parts[1]);
                }
            }
        }
        catch (Exception e) {
            versionInfo.setVersion("No Version Information Available");
        }
        return versionInfo;
    }
}

