/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.main.util.ArtifactResolver;

public class SimpleMavenResolver
implements ArtifactResolver {
    private static final Pattern mvnPattern = Pattern.compile("mvn:([^/ ]+)/([^/ ]+)/([^/ ]*)(/([^/ ]+)(/([^/ ]+))?)?");
    private final List<File> mavenRepos;

    public SimpleMavenResolver(List<File> mavenRepos) {
        this.mavenRepos = mavenRepos;
    }

    @Override
    public URI resolve(URI artifactUri) {
        for (File bundleDir : this.mavenRepos) {
            File file = SimpleMavenResolver.findFile(bundleDir, artifactUri);
            if (file == null) continue;
            return file.toURI();
        }
        throw new RuntimeException("Could not resolve " + artifactUri);
    }

    private static File findFile(File dir, URI mvnUri) {
        String path = SimpleMavenResolver.fromMaven(mvnUri);
        File theFile = new File(dir, path);
        if (theFile.exists() && !theFile.isDirectory()) {
            return theFile;
        }
        return null;
    }

    static String fromMaven(URI name) {
        Matcher m = mvnPattern.matcher(name.toString());
        if (!m.matches()) {
            return name.toString();
        }
        StringBuilder path = new StringBuilder();
        path.append(m.group(1).replace(".", "/"));
        path.append("/");
        String artifactId = m.group(2);
        String version = m.group(3);
        String extension = m.group(5);
        String classifier = m.group(7);
        path.append(artifactId).append("/");
        path.append(version).append("/");
        path.append(artifactId).append("-").append(version);
        if (SimpleMavenResolver.present(classifier)) {
            path.append("-").append(classifier);
        }
        if (SimpleMavenResolver.present(extension)) {
            path.append(".").append(extension);
        } else {
            path.append(".jar");
        }
        return path.toString();
    }

    private static boolean present(String part) {
        return part != null && !part.isEmpty();
    }
}

