/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.options;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.hadoop.db.TeradataConfiguration;
import java.io.File;
import java.util.ArrayList;
import org.apache.connectors.td.TeradataManager;
import org.apache.connectors.td.options.BooleanOption;
import org.apache.connectors.td.options.DefaultOption;
import org.apache.connectors.td.options.EnumOption;
import org.apache.connectors.td.options.NumberOption;
import org.apache.connectors.td.options.Option;
import org.apache.connectors.td.options.Options;
import org.apache.connectors.td.options.ParameterValidationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.sqoop.SqoopOptions;

public class TeradataImportOptions
extends Options {
    private ImportJobContext context;
    private static final Logger LOG = Logger.getLogger((String)TeradataImportOptions.class.getName());

    public TeradataImportOptions(ImportJobContext context) {
        this.context = context;
    }

    public static Options create(ImportJobContext context) {
        return new TeradataImportOptions(context).add(new EnumOption("jobtype", "hdfs", false, null, null, "hdfs", "hive", "hcat")).add(new EnumOption("fileformat", "textfile", false, null, null, "sequencefile", "textfile", "avrofile", "orcfile", "rcfile", "parquet")).add(new DefaultOption("method", "", true, null, null)).add(new DefaultOption("jobclientoutput", "", true, null, null)).add(new DefaultOption("nummappers", "", true, null, null)).add(new DefaultOption("debugoption", "", true, null, null)).add(new DefaultOption("sourcerecordschema", "", true, null, null)).add(new DefaultOption("targetrecordschema", "", true, null, null)).add(new DefaultOption("sourcedateformat", "", true, null, null)).add(new DefaultOption("targetdateformat", "", true, null, null)).add(new DefaultOption("sourcetimeformat", "", true, null, null)).add(new DefaultOption("targettimeformat", "", true, null, null)).add(new DefaultOption("sourcetimestampformat", "", true, null, null)).add(new DefaultOption("targettimestampformat", "", true, null, null)).add(new DefaultOption("sourcetimezoneid", "", true, null, null)).add(new DefaultOption("targettimezoneid", "", true, null, null)).add(new DefaultOption("classname", "", true, null, null)).add(new DefaultOption("url", "", true, null, null)).add(new DefaultOption("username", "", true, null, null)).add(new DefaultOption("password", "", true, null, null)).add(new NumberOption("batchsize", 10000, true, null, null)).add(new DefaultOption("queryband", "", true, null, null)).add(new BooleanOption("usexview", false, true, null, null)).add(new DefaultOption("separator", "", true, null, null)).add(new DefaultOption("lineseparator", "", true, null, null)).add(new DefaultOption("enclosedby", "", true, null, null)).add(new DefaultOption("escapedby", "", true, null, null)).add(new DefaultOption("nullstring", "", true, null, null)).add(new DefaultOption("nullnonstring", "", true, null, null)).add(new DefaultOption("avroschema", "", true, null, null)).add(new DefaultOption("avroschemafile", "", true, null, null)).add(new DefaultOption("hiveconf", "", true, null, null)).add(new DefaultOption("sourcedatabase", "", true, null, null)).add(new DefaultOption("sourcetable", "", true, null, null)).add(new DefaultOption("targetpaths", "", true, null, null)).add(new DefaultOption("targettableschema", "", true, null, null)).add(new DefaultOption("sourcepartitionschema", "", true, null, null)).add(new DefaultOption("sourcefieldnames", "", true, null, null)).add(new DefaultOption("sourcequery", "", true, null, null)).add(new DefaultOption("sourceconditions", "", true, null, null)).add(new DefaultOption("splitbycolumn", "", true, null, null)).add(new DefaultOption("forcestage", "", true, null, null)).add(new DefaultOption("stagedatabase", "", true, null, null)).add(new DefaultOption("stagetablename", "", true, null, null)).add(new BooleanOption("accesslock", false, true, null, null)).add(new DefaultOption("numpartitionsinstaging", "", true, null, null));
    }

    public ArrayList<String> prepare(Option opt) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("-" + opt.getName());
        vals.add(opt.getValue());
        return vals;
    }

    public void mapGenericOptions(Configuration conf) throws ParameterValidationException {
        if (this.context.getOptions().getClassName() == null) {
            TeradataConfiguration.setJDBCDriverClass((Configuration)conf, (String)"com.teradata.jdbc.TeraDriver");
        }
        TeradataConfiguration.setJDBCUsername((Configuration)conf, (String)this.context.getOptions().getUsername());
        TeradataConfiguration.setJDBCPassword((Configuration)conf, (String)this.context.getOptions().getPassword());
        TeradataConfiguration.setJDBCURL((Configuration)conf, (String)this.context.getOptions().getConnectString());
        int mappers = this.context.getOptions().getNumMappers();
        if (mappers > 0) {
            TeradataConfiguration.setInputNumMappers((Configuration)conf, (int)mappers);
            LOG.info((Object)("Setting number of mappers in TeradataConfiguration to " + mappers));
        }
    }

    public void mapImportOptions(Configuration conf, TeradataManager manager) throws Exception {
        String stagingTableName;
        TeradataConfiguration.setInputSourceTable((Configuration)conf, (String)this.context.getOptions().getTableName());
        LOG.info((Object)("Table name to import " + this.context.getOptions().getTableName()));
        Path targetPath = this.context.getDestination();
        String targetString = targetPath.toString();
        if (!targetPath.isAbsolute()) {
            String homeDir = new Path(targetString).getFileSystem(conf).getHomeDirectory().toString();
            targetString = homeDir + "/" + targetString;
        }
        TeradataConfiguration.setInputTargetPaths((Configuration)conf, (String)targetString);
        String whereClause = this.context.getOptions().getWhereClause();
        if (whereClause != null && !whereClause.isEmpty()) {
            TeradataConfiguration.setInputSourceConditions((Configuration)conf, (String)whereClause);
        }
        if (this.context.getOptions().getSplitByCol() != null) {
            TeradataConfiguration.setInputSplitByColumn((Configuration)conf, (String)this.context.getOptions().getSplitByCol());
            LOG.info((Object)("Setting split by column in TeradataConfiguration to " + this.context.getOptions().getSplitByCol()));
        }
        if (this.context.getOptions().getSqlQuery() != null) {
            TeradataConfiguration.setInputSourceQuery((Configuration)conf, (String)this.context.getOptions().getSqlQuery());
        }
        switch (this.context.getOptions().getFileLayout().toString().toLowerCase()) {
            case "avrodatafile": {
                TeradataConfiguration.setInputFileFormat((Configuration)conf, (String)"avrofile");
                break;
            }
            default: {
                TeradataConfiguration.setInputFileFormat((Configuration)conf, (String)"textfile");
            }
        }
        if (manager.getFileFromat() != null) {
            TeradataConfiguration.setInputFileFormat((Configuration)conf, (String)manager.getFileFromat());
        }
        LOG.info((Object)("Setting input file format in TeradataConfiguration to " + TeradataConfiguration.getInputFileFormat((Configuration)conf)));
        if (TeradataConfiguration.getInputFileFormat((Configuration)conf).equals("textfile")) {
            TeradataConfiguration.setInputSeparator((Configuration)conf, (String)String.format("\\u%04x", (short)this.context.getOptions().getOutputFieldDelim()));
            TeradataConfiguration.setInputLineSeparator((Configuration)conf, (String)String.format("\\u%04x", (short)this.context.getOptions().getInputRecordDelim()));
            String nullVal = this.context.getOptions().getNullStringValue();
            String nullVal2 = this.context.getOptions().getNullNonStringValue();
            if (nullVal != null) {
                TeradataConfiguration.setNullString((Configuration)conf, (String)nullVal);
            }
            if (nullVal2 != null) {
                TeradataConfiguration.setNullNonString((Configuration)conf, (String)nullVal2);
            }
            char enclosed = this.context.getOptions().getOutputEnclosedBy();
            char escaped = this.context.getOptions().getOutputEscapedBy();
            TeradataConfiguration.setInputEnclosedByString((Configuration)conf, (String)String.format("\\u%04x", (short)enclosed));
            TeradataConfiguration.setInputEscapedByString((Configuration)conf, (String)String.format("\\u%04x", (short)escaped));
            if (enclosed != '\u0000' || escaped != '\u0000') {
                TeradataConfiguration.setCustomParseMode((Configuration)conf, (boolean)true);
            }
            LOG.info((Object)("Setting input separator in TeradataConfiguration to " + TeradataConfiguration.getInputSeparator((Configuration)conf)));
        }
        if (this.context.getOptions().getColumns() != null) {
            TeradataConfiguration.setInputSourceFieldNames((Configuration)conf, (String)TeradataManager.join(this.context.getOptions().getColumns(), ","));
        }
        TeradataConnection c = new TeradataConnection("com.teradata.jdbc.TeraDriver", this.context.getOptions().getConnectString(), this.context.getOptions().getUsername(), this.context.getOptions().getPassword(), Boolean.valueOf(true));
        c.connect();
        if (this.context.getOptions().doHiveImport() || this.context.getOptions().getFileLayout().equals((Object)SqoopOptions.FileLayout.AvroDataFile) || this.context.getOptions().getHCatTableName() != null) {
            if (!this.get("targettableschema").hasValue()) {
                TeradataColumnDesc[] descriptors = this.context.getOptions().getSqlQuery() != null ? c.getColumnDescsForSQL(this.context.getOptions().getSqlQuery()) : (this.context.getOptions().getColumns() != null ? c.getColumnDescsForTable(this.context.getTableName(), this.context.getOptions().getColumns()) : c.getColumnDescsForTable(this.context.getTableName(), c.getColumnNamesForTable(this.context.getTableName())));
                this.generateSchemas(descriptors, conf, (SqoopOptions)this.context.getOptions(), this.context.getConnManager(), this.context.getOptions().getTableName());
                if (TeradataConfiguration.getInputFileFormat((Configuration)conf).equals("avrofile")) {
                    File avroSchemaFile = this.createAvroSchemaFile(this.getFields(), (SqoopOptions)this.context.getOptions());
                    LOG.info((Object)("Created Avro schema file: " + avroSchemaFile.getPath()));
                    TeradataConfiguration.setAvroSchemaFilePath((Configuration)conf, (String)avroSchemaFile.toURI().toString());
                }
                if (this.context.getOptions().doHiveImport()) {
                    this.context.getOptions().setColumns(this.getColumns().toArray(new String[this.getColumns().size()]));
                    TeradataConfiguration.setInputJobType((Configuration)conf, (String)"hive");
                    TeradataConfiguration.setHiveConfigureFile((Configuration)conf, (String)this.context.getOptions().getConf().getResource("hive-site.xml").toString());
                    TeradataConfiguration.setInputTargetTableSchema((Configuration)conf, (String)TeradataManager.join(this.getSchema().toArray(new String[1]), ","));
                }
            }
            if (this.context.getOptions().getHCatTableName() != null) {
                LOG.info((Object)"Setting job type in TeradataConfiguration to hcat");
                TeradataConfiguration.setInputJobType((Configuration)conf, (String)"hcat");
                TeradataConfiguration.setInputTargetTable((Configuration)conf, (String)this.context.getOptions().getHCatTableName());
                if (this.context.getOptions().getHCatDatabaseName() != null) {
                    TeradataConfiguration.setInputTargetDatabase((Configuration)conf, (String)this.context.getOptions().getHCatDatabaseName());
                }
            }
        }
        if ((stagingTableName = this.context.getOptions().getStagingTableName()) != null) {
            TeradataConfiguration.setInputStageTableName((Configuration)conf, (String)stagingTableName);
        }
        if (this.context.getOptions().getInputMethod() != null) {
            TeradataConfiguration.setInputMethod((Configuration)conf, (String)this.context.getOptions().getInputMethod());
            if (this.context.getOptions().getInputMethod().equals("split.by.partition")) {
                if (this.context.getOptions().getNumPartitionsForStagingTable() != 0) {
                    TeradataConfiguration.setInputNumPartitionsInStaging((Configuration)conf, (long)this.context.getOptions().getNumPartitionsForStagingTable());
                } else {
                    TeradataConfiguration.setInputNumPartitionsInStaging((Configuration)conf, (long)c.getTablePartitionCount(this.context.getTableName(), Boolean.valueOf(false)));
                }
            }
        }
        c.close();
        if (this.context.getOptions().getStagingDatabase() != null) {
            TeradataConfiguration.setInputStageDatabase((Configuration)conf, (String)this.context.getOptions().getStagingDatabase());
        }
        if (this.context.getOptions().getStagingForce() != null) {
            TeradataConfiguration.setInputStageForced((Configuration)conf, (boolean)this.context.getOptions().getStagingForce());
        }
        if (this.context.getOptions().getBatchSize() != 0) {
            TeradataConfiguration.setInputBatchSize((Configuration)conf, (int)this.context.getOptions().getBatchSize());
        }
        if (this.context.getOptions().getQueryBand() != null) {
            TeradataConfiguration.setInputQueryBand((Configuration)conf, (String)this.context.getOptions().getQueryBand());
        }
        if (this.context.getOptions().getSkipXviews().booleanValue()) {
            TeradataConfiguration.setDataDictionaryUseXViews((Configuration)conf, (boolean)false);
        }
        TeradataConfiguration.setInputAccessLock((Configuration)conf, (boolean)this.context.getOptions().getAccessLock());
        if (this.context.getOptions().getDateFormat() != null) {
            ConnectorConfiguration.setInputDateFormat((Configuration)conf, (String)this.context.getOptions().getDateFormat());
        }
        if (this.context.getOptions().getTimeFormat() != null) {
            ConnectorConfiguration.setInputTimeFormat((Configuration)conf, (String)this.context.getOptions().getTimeFormat());
        }
        if (this.context.getOptions().getTimestampFormat() != null) {
            ConnectorConfiguration.setInputTimestampFormat((Configuration)conf, (String)this.context.getOptions().getTimestampFormat());
        }
    }

    @Override
    public void mapOptions(Configuration conf, TeradataManager manager) throws Exception {
        this.mapGenericOptions(conf);
        this.mapImportOptions(conf, manager);
    }
}

