/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.options;

import com.cloudera.sqoop.manager.ConnManager;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.hadoop.db.TeradataConfiguration;
import java.io.File;
import java.util.ArrayList;
import org.apache.connectors.td.TeradataManager;
import org.apache.connectors.td.options.BooleanOption;
import org.apache.connectors.td.options.DefaultOption;
import org.apache.connectors.td.options.EnumOption;
import org.apache.connectors.td.options.NumberOption;
import org.apache.connectors.td.options.Option;
import org.apache.connectors.td.options.Options;
import org.apache.connectors.td.options.ParameterValidationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ExportJobContext;

public class TeradataExportOptions
extends Options {
    private ExportJobContext context;
    private static final Logger LOG = Logger.getLogger((String)TeradataExportOptions.class.getName());

    public TeradataExportOptions(ExportJobContext context) {
        this.context = context;
    }

    public static Options create(ExportJobContext context) {
        return new TeradataExportOptions(context).add(new EnumOption("jobtype", "hdfs", false, null, null, "hdfs", "hive", "hcat")).add(new EnumOption("fileformat", "textfile", false, null, null, "sequencefile", "textfile", "avrofile", "orcfile", "rcfile")).add(new DefaultOption("classname", "", true, null, null)).add(new DefaultOption("url", "", true, null, null)).add(new DefaultOption("username", "", true, null, null)).add(new DefaultOption("password", "", true, null, null)).add(new NumberOption("batchsize", 10000, true, null, null)).add(new BooleanOption("accesslock", false, true, null, null)).add(new DefaultOption("queryband", "", true, null, null)).add(new DefaultOption("sourcepaths", "", true, null, null)).add(new DefaultOption("sourcetable", "", true, null, null)).add(new DefaultOption("sourceconditions", "", true, null, null)).add(new DefaultOption("sourcefieldnames", "", true, null, null)).add(new DefaultOption("sourcerecordschema", "", true, null, null)).add(new DefaultOption("targetrecordschema", "", true, null, null)).add(new DefaultOption("sourcequery", "", true, null, null)).add(new DefaultOption("sourcecountquery", "", true, null, null)).add(new DefaultOption("targetdatabase", "", true, null, null)).add(new DefaultOption("targettable", "", true, null, null)).add(new DefaultOption("targetfieldnames", "", true, null, null)).add(new DefaultOption("targettableschema", "", true, null, null)).add(new DefaultOption("targetpartitionschema", "", true, null, null)).add(new DefaultOption("separator", "", true, null, null)).add(new DefaultOption("lineseparator", "", true, null, null)).add(new DefaultOption("enclosedby", "", true, null, null)).add(new DefaultOption("escapedby", "", true, null, null)).add(new DefaultOption("nullstring", "", true, null, null)).add(new DefaultOption("nullnonstring", "", true, null, null)).add(new DefaultOption("method", "", true, null, null)).add(new DefaultOption("nummappers", "", true, null, null)).add(new DefaultOption("splitbycolumn", "", true, null, null)).add(new DefaultOption("forcestage", "", true, null, null)).add(new DefaultOption("stagetablename", "", true, null, null)).add(new DefaultOption("stagedatabase", "", true, null, null)).add(new DefaultOption("numpartitionsinstaging", "", true, null, null)).add(new DefaultOption("hiveconf", "", true, null, null)).add(new BooleanOption("usexview", false, true, null, null)).add(new DefaultOption("avroschema", "", true, null, null)).add(new DefaultOption("avroschemafile", "", true, null, null)).add(new DefaultOption("debugoption", "", true, null, null)).add(new DefaultOption("sourcedateformat", "", true, null, null)).add(new DefaultOption("targetdateformat", "", true, null, null)).add(new DefaultOption("sourcetimeformat", "", true, null, null)).add(new DefaultOption("targettimeformat", "", true, null, null)).add(new DefaultOption("sourcetimestampformat", "", true, null, null)).add(new DefaultOption("targettimestampformat", "", true, null, null)).add(new DefaultOption("sourcetimezoneid", "", true, null, null)).add(new DefaultOption("targettimezoneid", "", true, null, null));
    }

    public ArrayList<String> prepare(Option opt) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("-" + opt.getName());
        vals.add(opt.getValue());
        return vals;
    }

    public void mapGenericOptions(Configuration conf) throws ParameterValidationException {
        if (this.context.getOptions().getClassName() == null) {
            TeradataConfiguration.setJDBCDriverClass((Configuration)conf, (String)"com.teradata.jdbc.TeraDriver");
        }
        TeradataConfiguration.setJDBCUsername((Configuration)conf, (String)this.context.getOptions().getUsername());
        TeradataConfiguration.setJDBCPassword((Configuration)conf, (String)this.context.getOptions().getPassword());
        TeradataConfiguration.setJDBCURL((Configuration)conf, (String)this.context.getOptions().getConnectString());
        int mappers = this.context.getOptions().getNumMappers();
        if (mappers > 0) {
            TeradataConfiguration.setOutputNumMappers((Configuration)conf, (int)mappers);
            LOG.info((Object)("Setting number of mappers in TeradataConfiguration to " + mappers));
        }
        TeradataConfiguration.setOutputTargetTable((Configuration)conf, (String)this.context.getOptions().getTableName());
        LOG.info((Object)("Setting output table in TeradataConfiguration to " + this.context.getOptions().getTableName()));
        String[] colNames = this.context.getOptions().getColumns();
        if (colNames != null) {
            TeradataConfiguration.setOutputTargetFieldNamesArray((Configuration)conf, (String[])colNames);
        }
    }

    public void mapExportOptions(Configuration conf, TeradataManager manager) throws Exception {
        String stagingTableName;
        switch (this.context.getOptions().getFileLayout().toString().toLowerCase()) {
            case "avrodatafile": {
                TeradataConfiguration.setOutputFileFormat((Configuration)conf, (String)"avrofile");
                break;
            }
            default: {
                TeradataConfiguration.setOutputFileFormat((Configuration)conf, (String)"textfile");
            }
        }
        if (manager.getFileFromat() != null) {
            TeradataConfiguration.setOutputFileFormat((Configuration)conf, (String)manager.getFileFromat());
        }
        LOG.info((Object)("Setting output file format in TeradataConfiguration to " + TeradataConfiguration.getOutputFileFormat((Configuration)conf)));
        TeradataConfiguration.setOutputSeparator((Configuration)conf, (String)String.format("\\u%04x", (short)this.context.getOptions().getInputFieldDelim()));
        TeradataConfiguration.setOutputLineSeparator((Configuration)conf, (String)String.format("\\u%04x", (short)this.context.getOptions().getInputRecordDelim()));
        String nullVal = this.context.getOptions().getNullStringValue();
        String nullVal2 = this.context.getOptions().getNullNonStringValue();
        if (nullVal != null) {
            TeradataConfiguration.setNullString((Configuration)conf, (String)nullVal);
        }
        if (nullVal2 != null) {
            TeradataConfiguration.setNullNonString((Configuration)conf, (String)nullVal2);
        }
        char enclosed = this.context.getOptions().getOutputEnclosedBy();
        char escaped = this.context.getOptions().getOutputEscapedBy();
        TeradataConfiguration.setOutputEnclosedByString((Configuration)conf, (String)String.format("\\u%04x", (short)enclosed));
        TeradataConfiguration.setOutputEscapedByString((Configuration)conf, (String)String.format("\\u%04x", (short)escaped));
        if (enclosed != '\u0000' || escaped != '\u0000') {
            TeradataConfiguration.setCustomParseMode((Configuration)conf, (boolean)true);
        }
        LOG.info((Object)("Setting output separator in TeradataConfiguration to " + TeradataConfiguration.getOutputSeparator((Configuration)conf)));
        if (TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("rcfile") || TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("orcfile") || TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("avrofile")) {
            TeradataConnection c = new TeradataConnection("com.teradata.jdbc.TeraDriver", this.context.getOptions().getConnectString(), this.context.getOptions().getUsername(), this.context.getOptions().getPassword(), Boolean.valueOf(true));
            c.connect();
            TeradataColumnDesc[] descriptors = this.context.getOptions().getSqlQuery() != null ? c.getColumnDescsForSQL(this.context.getOptions().getSqlQuery()) : c.getColumnDescsForTable(this.context.getTableName(), c.getColumnNamesForTable(this.context.getTableName()));
            c.close();
            this.generateSchemas(descriptors, conf, (SqoopOptions)this.context.getOptions(), (ConnManager)this.context.getConnManager(), this.context.getOptions().getTableName());
            if (TeradataConfiguration.getInputFileFormat((Configuration)conf).equals("avrofile")) {
                File avroSchemaFile = this.createAvroSchemaFile(this.getFields(), (SqoopOptions)this.context.getOptions());
                LOG.info((Object)("Created Avro schema file: " + avroSchemaFile.getPath()));
                TeradataConfiguration.setAvroSchemaFilePath((Configuration)conf, (String)avroSchemaFile.toURI().toString());
            }
        }
        if ((stagingTableName = this.context.getOptions().getStagingTableName()) != null) {
            TeradataConfiguration.setOutputStageTableName((Configuration)conf, (String)stagingTableName);
        }
        if (this.context.getOptions().getHCatTableName() != null) {
            TeradataConfiguration.setOutputJobType((Configuration)conf, (String)"hcat");
            TeradataConfiguration.setOutputSourceTable((Configuration)conf, (String)this.context.getOptions().getHCatTableName());
            if (this.context.getOptions().getHCatDatabaseName() != null) {
                TeradataConfiguration.setOutputSourceDatabase((Configuration)conf, (String)this.context.getOptions().getHCatDatabaseName());
            }
        } else {
            if (TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("rcfile") || TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("orcfile")) {
                TeradataConfiguration.setOutputJobType((Configuration)conf, (String)"hive");
                TeradataConfiguration.setHiveConfigureFile((Configuration)conf, (String)this.context.getOptions().getConf().getResource("hive-site.xml").toString());
                TeradataConfiguration.setOutputSourceTableSchema((Configuration)conf, (String)TeradataManager.join(this.getSchema().toArray(new String[1]), ","));
            } else {
                if (!TeradataConfiguration.getOutputFileFormat((Configuration)conf).equals("avrofile")) {
                    TeradataConfiguration.setOutputFileFormat((Configuration)conf, (String)"textfile");
                }
                TeradataConfiguration.setOutputJobType((Configuration)conf, (String)"hdfs");
            }
            TeradataConfiguration.setOutputSourcePaths((Configuration)conf, (String)this.context.getOptions().getExportDir());
            LOG.info((Object)("Setting export source path in TeradataConfiguration to: " + this.context.getOptions().getExportDir()));
        }
        if (this.context.getOptions().getColumns() != null) {
            String columnString = TeradataManager.join(this.context.getOptions().getColumns(), ",");
            TeradataConfiguration.setOutputTargetFieldNames((Configuration)conf, (String)columnString);
            TeradataConfiguration.setOutputSourceFieldNames((Configuration)conf, (String)columnString);
            LOG.info((Object)("Setting target field columns to: " + columnString));
        }
        if (this.context.getOptions().getOutputMethod() != null) {
            TeradataConfiguration.setOutputMethod((Configuration)conf, (String)this.context.getOptions().getOutputMethod());
        }
        if (this.context.getOptions().getKeepStagingTable() != null) {
            TeradataConfiguration.setOutputStageTableKept((Configuration)conf, (Boolean)this.context.getOptions().getKeepStagingTable());
        }
        if (this.context.getOptions().getStagingDatabase() != null) {
            TeradataConfiguration.setOutputStageDatabase((Configuration)conf, (String)this.context.getOptions().getStagingDatabase());
        }
        if (this.context.getOptions().getStagingForce() != null) {
            TeradataConfiguration.setOutputStageForced((Configuration)conf, (boolean)this.context.getOptions().getStagingForce());
        }
        if (this.context.getOptions().getFastloadSocketHostname() != null) {
            TeradataConfiguration.setOutputFastloadSocketHost((Configuration)conf, (String)this.context.getOptions().getFastloadSocketHostname());
        }
        if (this.context.getOptions().getFastloadSocketPort() != 0) {
            TeradataConfiguration.setOutputFastloadSocketPort((Configuration)conf, (Integer)this.context.getOptions().getFastloadSocketPort());
        }
        if (this.context.getOptions().getFastloadSocketTimeout() != 480000L) {
            TeradataConfiguration.setOutputFastloadSocketTimeout((Configuration)conf, (Long)this.context.getOptions().getFastloadSocketTimeout());
        }
        if (this.context.getOptions().getBatchSize() != 0) {
            TeradataConfiguration.setOutputBatchSize((Configuration)conf, (Integer)this.context.getOptions().getBatchSize());
        }
        if (this.context.getOptions().getQueryBand() != null) {
            TeradataConfiguration.setOutputQueryBand((Configuration)conf, (String)this.context.getOptions().getQueryBand());
        }
        if (this.context.getOptions().getSkipXviews().booleanValue()) {
            TeradataPlugInConfiguration.setOutputDataDictionaryUseXView((Configuration)conf, (boolean)false);
        }
        if (this.context.getOptions().getErrorTable() != null) {
            TeradataPlugInConfiguration.setOutputErrorTableName((Configuration)conf, (String)this.context.getOptions().getErrorTable());
        }
        if (this.context.getOptions().getErrorDatabase() != null) {
            TeradataPlugInConfiguration.setOutputErrorTableDatabase((Configuration)conf, (String)this.context.getOptions().getErrorDatabase());
        }
        if (this.context.getOptions().getDateFormat() != null) {
            ConnectorConfiguration.setInputDateFormat((Configuration)conf, (String)this.context.getOptions().getDateFormat());
        }
        if (this.context.getOptions().getTimeFormat() != null) {
            ConnectorConfiguration.setInputTimeFormat((Configuration)conf, (String)this.context.getOptions().getTimeFormat());
        }
        if (this.context.getOptions().getTimestampFormat() != null) {
            ConnectorConfiguration.setInputTimestampFormat((Configuration)conf, (String)this.context.getOptions().getTimestampFormat());
        }
    }

    @Override
    public void mapOptions(Configuration conf, TeradataManager manager) throws Exception {
        this.mapGenericOptions(conf);
        this.mapExportOptions(conf, manager);
    }
}

