/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import com.teradata.connector.common.tool.ConfigurationMappingUtils;
import com.teradata.connector.common.tool.ConnectorJobRunner;
import com.teradata.connector.teradata.db.TeradataConnection;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.connectors.td.options.Options;
import org.apache.connectors.td.options.TeradataExportOptions;
import org.apache.connectors.td.options.TeradataImportOptions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sqoop.manager.CatalogQueryManager;

public class TeradataManager
extends CatalogQueryManager {
    private static final Logger LOG = Logger.getLogger((String)TeradataManager.class.getName());
    public static final String TD_PREFIX = "tdch.";
    private String fileFormat;

    public TeradataManager(SqoopOptions opts) {
        super("com.teradata.jdbc.TeraDriver", opts);
        Configuration conf = opts.getConf();
        if (conf.get("tdch.fileformat") != null) {
            this.fileFormat = conf.get("tdch.fileformat");
        }
    }

    protected String getListColumnsQuery(String tableName) {
        return TeradataConnection.getListColumnsSQL((String)tableName, (boolean)true);
    }

    protected String getListDatabasesQuery() {
        return TeradataConnection.getDatabaseSQL();
    }

    protected String getListTablesQuery() {
        return TeradataConnection.getListTablesSQL(null, (boolean)true);
    }

    protected String getPrimaryKeyQuery(String tableName) {
        return TeradataConnection.getPrimaryKeySQL((String)tableName, (boolean)true);
    }

    public String getFileFromat() {
        return this.fileFormat;
    }

    protected void checkTableImportOptions(ImportJobContext context) throws IOException, ImportException {
        SqoopOptions options = context.getOptions();
        super.checkTableImportOptions(context);
    }

    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager((ConnManager)this);
        Configuration conf = context.getOptions().getConf();
        Configuration.addDefaultResource((String)"teradata-export-properties.xml");
        Options tdOpts = TeradataExportOptions.create((org.apache.sqoop.manager.ExportJobContext)context);
        this.addLibsToCache(conf, context.getOptions());
        try {
            tdOpts.mapOptions(conf, this);
            ConfigurationMappingUtils.exportConfigurationMapping((Configuration)conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ConnectorJobRunner.runJob((Configuration)conf);
    }

    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager((ConnManager)this);
        Configuration conf = context.getOptions().getConf();
        Configuration.addDefaultResource((String)"teradata-import-properties.xml");
        Options tdOpts = TeradataImportOptions.create(context);
        this.addLibsToCache(conf, context.getOptions());
        try {
            tdOpts.mapOptions(conf, this);
            ConfigurationMappingUtils.importConfigurationMapping((Configuration)conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ConnectorJobRunner.runJob((Configuration)conf);
    }

    public static String join(String[] aArr, String sSep) {
        StringBuilder sbStr = new StringBuilder();
        int il = aArr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sSep);
            }
            sbStr.append(aArr[i]);
        }
        return sbStr.toString();
    }

    public void addLibsToCache(Configuration conf, SqoopOptions options) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> localUrls = new HashSet<String>();
        String sqoopHome = System.getenv("SQOOP_HOME");
        String hiveHome = options.getHiveHome();
        if (hiveHome != null) {
            LOG.info((Object)("HIVE HOME set to " + hiveHome));
        } else {
            hiveHome = System.getenv("HIVE_HOME");
        }
        String hcatHome = options.getHCatHome();
        if (hcatHome != null) {
            LOG.info((Object)("HCAT HOME set to " + hcatHome));
        } else {
            hcatHome = System.getenv("HCAT_HOME");
        }
        if (null != hiveHome) {
            this.addJarsToChache(hiveHome, fs, localUrls, conf);
        } else {
            LOG.warn((Object)"HIVE_HOME is unset. May not be able to find all job dependencies.");
        }
        if (null != hcatHome && null != hiveHome) {
            this.addJarsToChache(hcatHome, fs, localUrls, conf);
        } else {
            this.addJarsToChache(hiveHome + "hcatalog", fs, localUrls, conf);
        }
        if (null != sqoopHome) {
            this.addJarsToChache(sqoopHome, fs, localUrls, conf);
        } else {
            LOG.warn((Object)"SQOOP_HOME is unset. May not be able to find all job dependencies.");
        }
        if (localUrls.isEmpty()) {
            return;
        }
        String tmpjars = TestBlockStoragePolicy.conf.get("tmpjars");
        StringBuilder sb = new StringBuilder();
        if (null != tmpjars) {
            sb.append(tmpjars);
            sb.append(",");
        }
        sb.append(StringUtils.join((CharSequence)",", (String[])localUrls.toArray(new String[0])));
        conf.set("tmpjars", sb.toString());
    }

    private void addJarsToChache(String home, LocalFileSystem fs, HashSet<String> localUrls, Configuration conf) {
        File homeFile = new File(home);
        File libFile = !home.contains("hcatalog") ? new File(homeFile, "lib") : new File(homeFile, "share/hcatalog");
        if (libFile.exists()) {
            this.addDirToCache(libFile, (FileSystem)fs, localUrls);
        }
    }

    public void addDirToCache(File dir, FileSystem fs, Set<String> localUrls) {
        if (null == dir) {
            return;
        }
        for (File libfile : dir.listFiles()) {
            if (!libfile.exists() || libfile.isDirectory() || !libfile.getName().endsWith("jar")) continue;
            this.addToCache(libfile.toString(), fs, localUrls);
        }
    }

    public void addToCache(String file, FileSystem fs, Set<String> localUrls) {
        if (null == file) {
            return;
        }
        Path p = new Path(file);
        String qualified = p.makeQualified(fs).toString();
        LOG.debug((Object)("Adding to job classpath: " + qualified));
        localUrls.add(qualified);
    }
}

