/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.step.exit;

import java.util.Arrays;
import java.util.List;
import org.pentaho.big.data.kettle.plugins.mapreduce.DialogClassUtil;
import org.pentaho.big.data.kettle.plugins.mapreduce.step.exit.HadoopExit;
import org.pentaho.big.data.kettle.plugins.mapreduce.step.exit.HadoopExitData;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="HadoopExitPlugin", image="MRO.svg", name="HadoopExitPlugin.Name", description="HadoopExitPlugin.Description", documentationUrl="Products/MapReduce_Output", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hadoopexit")
@InjectionSupported(localizationPrefix="HadoopExitPlugin.Injection.")
public class HadoopExitMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String ERROR_INVALID_KEY_FIELD = "Error.InvalidKeyField";
    public static final String ERROR_INVALID_VALUE_FIELD = "Error.InvalidValueField";
    public static final String OUT_KEY = "outKey";
    public static final String OUT_VALUE = "outValue";
    public static final String HADOOP_EXIT_META_CHECK_RESULT_NO_DATA_STREAM = "HadoopExitMeta.CheckResult.NoDataStream";
    public static final String HADOOP_EXIT_META_CHECK_RESULT_NO_SPECIFIED_FIELDS = "HadoopExitMeta.CheckResult.NoSpecifiedFields";
    public static final String HADOOP_EXIT_META_CHECK_RESULT_STEP_RECEVING_DATA = "HadoopExitMeta.CheckResult.StepRecevingData";
    public static final String HADOOP_EXIT_META_CHECK_RESULT_NOT_RECEVING_SPECIFIED_FIELDS = "HadoopExitMeta.CheckResult.NotRecevingSpecifiedFields";
    public static Class<?> PKG = HadoopExit.class;
    public static final String DIALOG_NAME = DialogClassUtil.getDialogClassName(PKG);
    public static String OUT_KEY_FIELDNAME = "outkeyfieldname";
    public static String OUT_VALUE_FIELDNAME = "outvaluefieldname";
    @Injection(name="KEY_FIELD")
    private String outKeyFieldname;
    @Injection(name="VALUE_FIELD")
    private String outValueFieldname;

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.setOutKeyFieldname(XMLHandler.getTagValue((Node)stepnode, (String)OUT_KEY_FIELDNAME));
        this.setOutValueFieldname(XMLHandler.getTagValue((Node)stepnode, (String)OUT_VALUE_FIELDNAME));
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)OUT_KEY_FIELDNAME, (String)this.getOutKeyFieldname()));
        retval.append("    ").append(XMLHandler.addTagValue((String)OUT_VALUE_FIELDNAME, (String)this.getOutValueFieldname()));
        return retval.toString();
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.setOutKeyFieldname(null);
        this.setOutValueFieldname(null);
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.setOutKeyFieldname(rep.getStepAttributeString(id_step, OUT_KEY_FIELDNAME));
        this.setOutValueFieldname(rep.getStepAttributeString(id_step, OUT_VALUE_FIELDNAME));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, OUT_KEY_FIELDNAME, this.getOutKeyFieldname());
        rep.saveStepAttribute(id_transformation, id_step, OUT_VALUE_FIELDNAME, this.getOutValueFieldname());
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMetaInterface key = rowMeta.searchValueMeta(this.getOutKeyFieldname());
        ValueMetaInterface value = rowMeta.searchValueMeta(this.getOutValueFieldname());
        if (key == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)ERROR_INVALID_KEY_FIELD, (String[])new String[]{this.getOutKeyFieldname()}));
        }
        if (value == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)ERROR_INVALID_VALUE_FIELD, (String[])new String[]{this.getOutValueFieldname()}));
        }
        ValueMetaInterface keyMeta = key.clone();
        ValueMetaInterface valueMeta = value.clone();
        keyMeta.setName(OUT_KEY);
        valueMeta.setName(OUT_VALUE);
        rowMeta.clear();
        rowMeta.addValueMeta(keyMeta);
        rowMeta.addValueMeta(valueMeta);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (prev == null || prev.size() == 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)HADOOP_EXIT_META_CHECK_RESULT_NO_DATA_STREAM, (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            List<String> fieldnames = Arrays.asList(prev.getFieldNames());
            HadoopExitMeta stepMeta = (HadoopExitMeta)stepinfo.getStepMetaInterface();
            if (stepMeta.getOutKeyFieldname() == null || stepMeta.getOutValueFieldname() == null) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)HADOOP_EXIT_META_CHECK_RESULT_NO_SPECIFIED_FIELDS, (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else if (fieldnames.contains(stepMeta.getOutKeyFieldname()) && fieldnames.contains(stepMeta.getOutValueFieldname())) {
                CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)HADOOP_EXIT_META_CHECK_RESULT_STEP_RECEVING_DATA, (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)HADOOP_EXIT_META_CHECK_RESULT_NOT_RECEVING_SPECIFIED_FIELDS, (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new HadoopExit(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new HadoopExitData();
    }

    public String getOutKeyFieldname() {
        return this.outKeyFieldname;
    }

    public void setOutKeyFieldname(String arg) {
        this.outKeyFieldname = arg;
    }

    public String getOutValueFieldname() {
        return this.outValueFieldname;
    }

    public void setOutValueFieldname(String arg) {
        this.outValueFieldname = arg;
    }

    public String getDialogClassName() {
        return DIALOG_NAME;
    }
}

