/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordReaderWrapper
implements org.apache.hadoop.mapred.RecordReader<NullWritable, ArrayWritable> {
    public static final Logger LOG = LoggerFactory.getLogger(ParquetRecordReaderWrapper.class);
    private final long splitLen;
    private RecordReader<Void, ArrayWritable> realReader;
    private ArrayWritable valueObj = null;
    private boolean firstRecord = false;
    private boolean eof = false;
    private int schemaSize;
    private boolean skipTimestampConversion = false;
    private JobConf jobConf;
    private final ProjectionPusher projectionPusher;
    private List<BlockMetaData> filtedBlocks;

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException, InterruptedException {
        this(newInputFormat, oldSplit, oldJobConf, reporter, new ProjectionPusher());
    }

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, ProjectionPusher pusher) throws IOException, InterruptedException {
        JobConf conf;
        this.splitLen = oldSplit.getLength();
        this.projectionPusher = pusher;
        this.jobConf = oldJobConf;
        ParquetInputSplit split = this.getSplit(oldSplit, this.jobConf);
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)this.jobConf.get("mapred.task.id"));
        if (taskAttemptID == null) {
            taskAttemptID = new TaskAttemptID();
        }
        if (this.skipTimestampConversion ^ HiveConf.getBoolVar((Configuration)(conf = this.jobConf), HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)) {
            conf = new JobConf((Configuration)oldJobConf);
            HiveConf.setBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION, this.skipTimestampConversion);
        }
        TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)conf, taskAttemptID);
        if (split != null) {
            try {
                this.realReader = newInputFormat.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)split, taskContext);
                this.realReader.initialize((org.apache.hadoop.mapreduce.InputSplit)split, taskContext);
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueObj = (ArrayWritable)this.realReader.getCurrentValue();
                }
                this.eof = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else {
            this.realReader = null;
            this.eof = true;
        }
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schemaSize]);
        }
    }

    public FilterCompat.Filter setFilter(JobConf conf, MessageType schema) {
        SearchArgument sarg = ConvertAstToSearchArg.createFromConf((Configuration)conf);
        if (sarg == null) {
            return null;
        }
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate(sarg, schema);
        if (p != null) {
            LOG.debug("PARQUET predicate push down generated.");
            ParquetInputFormat.setFilterPredicate((Configuration)conf, p);
            return FilterCompat.get(p);
        }
        LOG.debug("No PARQUET predicate push down is generated.");
        return null;
    }

    public void close() throws IOException {
        if (this.realReader != null) {
            this.realReader.close();
        }
    }

    public NullWritable createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLen * this.getProgress());
    }

    public float getProgress() throws IOException {
        if (this.realReader == null) {
            return 1.0f;
        }
        try {
            return this.realReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.eof) {
            return false;
        }
        try {
            if (this.firstRecord) {
                this.firstRecord = false;
            } else if (!this.realReader.nextKeyValue()) {
                this.eof = true;
                return false;
            }
            ArrayWritable tmpCurValue = (ArrayWritable)this.realReader.getCurrentValue();
            if (value != tmpCurValue) {
                Writable[] arrValue = value.get();
                Writable[] arrCurrent = tmpCurValue.get();
                if (value != null && arrValue.length == arrCurrent.length) {
                    System.arraycopy(arrCurrent, 0, arrValue, 0, arrCurrent.length);
                } else {
                    if (arrValue.length != arrCurrent.length) {
                        throw new IOException("DeprecatedParquetHiveInput : size of object differs. Value size :  " + arrValue.length + ", Current Object size : " + arrCurrent.length);
                    }
                    throw new IOException("DeprecatedParquetHiveInput can not support RecordReaders that don't return same key & value & value is null");
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected ParquetInputSplit getSplit(InputSplit oldSplit, JobConf conf) throws IOException {
        if (oldSplit instanceof FileSplit) {
            Path finalPath = ((FileSplit)oldSplit).getPath();
            this.jobConf = this.projectionPusher.pushProjectionsAndFilters(conf, finalPath.getParent());
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)this.jobConf, finalPath);
            List<BlockMetaData> blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            ReadSupport.ReadContext readContext = new DataWritableReadSupport().init(new InitContext((Configuration)this.jobConf, null, fileMetaData.getSchema()));
            this.schemaSize = MessageTypeParser.parseMessageType(readContext.getReadSupportMetadata().get("HIVE_TABLE_SCHEMA")).getFieldCount();
            ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
            long splitStart = ((FileSplit)oldSplit).getStart();
            long splitLength = ((FileSplit)oldSplit).getLength();
            for (BlockMetaData block : blocks) {
                long firstDataPage = block.getColumns().get(0).getFirstDataPageOffset();
                if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
                splitGroup.add(block);
            }
            if (splitGroup.isEmpty()) {
                LOG.warn("Skipping split, could not find row group in: " + (FileSplit)oldSplit);
                return null;
            }
            FilterCompat.Filter filter = this.setFilter(this.jobConf, fileMetaData.getSchema());
            if (filter != null) {
                this.filtedBlocks = RowGroupFilter.filterRowGroups(filter, splitGroup, fileMetaData.getSchema());
                if (this.filtedBlocks.isEmpty()) {
                    LOG.debug("All row groups are dropped due to filter predicates");
                    return null;
                }
                long droppedBlocks = splitGroup.size() - this.filtedBlocks.size();
                if (droppedBlocks > 0L) {
                    LOG.debug("Dropping " + droppedBlocks + " row groups that do not pass filter predicate");
                }
            } else {
                this.filtedBlocks = splitGroup;
            }
            if (HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)) {
                this.skipTimestampConversion = !Strings.nullToEmpty(fileMetaData.getCreatedBy()).startsWith("parquet-mr");
            }
            ParquetInputSplit split = new ParquetInputSplit(finalPath, splitStart, splitLength, ((FileSplit)oldSplit).getLocations(), this.filtedBlocks, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
            return split;
        }
        throw new IllegalArgumentException("Unknown split type: " + oldSplit);
    }

    public List<BlockMetaData> getFiltedBlocks() {
        return this.filtedBlocks;
    }
}

