/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.TextInputFormat;

public class SymbolicInputFormat
implements ReworkMapredInputFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rework(HiveConf job, MapredWork work) throws IOException {
        LinkedHashMap<String, PartitionDesc> pathToParts = work.getMapWork().getPathToPartitionInfo();
        ArrayList<String> toRemovePaths = new ArrayList<String>();
        HashMap<String, PartitionDesc> toAddPathToPart = new HashMap<String, PartitionDesc>();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = work.getMapWork().getPathToAliases();
        for (Map.Entry pathPartEntry : pathToParts.entrySet()) {
            String path = (String)pathPartEntry.getKey();
            PartitionDesc partDesc = (PartitionDesc)pathPartEntry.getValue();
            if (!partDesc.getInputFileFormatClass().equals(SymlinkTextInputFormat.class)) continue;
            partDesc.setInputFileFormatClass(TextInputFormat.class);
            Path symlinkDir = new Path(path);
            FileSystem fileSystem = symlinkDir.getFileSystem((Configuration)job);
            FileStatus fStatus = fileSystem.getFileStatus(symlinkDir);
            FileStatus[] symlinks = null;
            symlinks = !fStatus.isDir() ? new FileStatus[]{fStatus} : fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            toRemovePaths.add(path);
            ArrayList aliases = (ArrayList)pathToAliases.remove(path);
            for (FileStatus symlink : symlinks) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath())));
                    partDesc.setInputFileFormatClass(TextInputFormat.class);
                    while ((line = reader.readLine()) != null) {
                        FileStatus[] matches;
                        for (FileStatus fileStatus : matches = fileSystem.globStatus(new Path(line))) {
                            toAddPathToPart.put(fileStatus.getPath().toUri().getPath(), partDesc);
                            pathToAliases.put(fileStatus.getPath().toUri().getPath(), aliases);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)reader);
            }
        }
        pathToParts.putAll(toAddPathToPart);
        for (String toRemove : toRemovePaths) {
            pathToParts.remove(toRemove);
        }
    }
}

