/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import org.apache.hadoop.hive.ql.index.AggregateIndexHandler;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapIndexHandler;
import org.apache.hadoop.hive.ql.index.compact.CompactIndexHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIndex {
    public static final Logger l4j = LoggerFactory.getLogger((String)"HiveIndex");
    public static String INDEX_TABLE_CREATETIME = "hive.index.basetbl.dfs.lastModifiedTime";

    public static IndexType getIndexType(String name) {
        IndexType[] types;
        for (IndexType type : types = IndexType.values()) {
            if (!type.getName().equals(name.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static IndexType getIndexTypeByClassName(String className) {
        IndexType[] types;
        for (IndexType type : types = IndexType.values()) {
            if (!type.getHandlerClsName().equals(className)) continue;
            return type;
        }
        return null;
    }

    public static enum IndexType {
        AGGREGATE_TABLE("aggregate", AggregateIndexHandler.class.getName()),
        COMPACT_SUMMARY_TABLE("compact", CompactIndexHandler.class.getName()),
        BITMAP_TABLE("bitmap", BitmapIndexHandler.class.getName());

        private final String indexTypeName;
        private final String handlerClsName;

        private IndexType(String indexType, String className) {
            this.indexTypeName = indexType;
            this.handlerClsName = className;
        }

        public String getName() {
            return this.indexTypeName;
        }

        public String getHandlerClsName() {
            return this.handlerClsName;
        }
    }
}

