/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.DataOutputBuffer;

public class VectorGroupKeyHelper
extends VectorColumnSetInfo {
    public VectorGroupKeyHelper(int keyCount) {
        super(keyCount);
    }

    void init(VectorExpression[] keyExpressions) throws HiveException {
        for (int i = 0; i < keyExpressions.length; ++i) {
            this.addKey(keyExpressions[i].getOutputType());
        }
        this.finishAdding();
    }

    public void copyGroupKey(VectorizedRowBatch inputBatch, VectorizedRowBatch outputBatch, DataOutputBuffer buffer) throws HiveException {
        ColumnVector outputColumnVector;
        ColumnVector inputColumnVector;
        int keyIndex;
        int i;
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            inputColumnVector = (LongColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (LongColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                ((LongColumnVector)outputColumnVector).vector[outputBatch.size] = inputColumnVector.vector[0];
                continue;
            }
            ((LongColumnVector)outputColumnVector).noNulls = false;
            ((LongColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            inputColumnVector = (DoubleColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (DoubleColumnVector)outputBatch.cols[keyIndex];
            if (((DoubleColumnVector)inputColumnVector).noNulls || !((DoubleColumnVector)inputColumnVector).isNull[0]) {
                ((DoubleColumnVector)outputColumnVector).vector[outputBatch.size] = ((DoubleColumnVector)inputColumnVector).vector[0];
                continue;
            }
            ((DoubleColumnVector)outputColumnVector).noNulls = false;
            ((DoubleColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            inputColumnVector = (BytesColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (BytesColumnVector)outputBatch.cols[keyIndex];
            if (((BytesColumnVector)inputColumnVector).noNulls || !((BytesColumnVector)inputColumnVector).isNull[0]) {
                int start = buffer.getLength();
                int length = ((BytesColumnVector)inputColumnVector).length[0];
                try {
                    buffer.write(((BytesColumnVector)inputColumnVector).vector[0], ((BytesColumnVector)inputColumnVector).start[0], length);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("bad write", ioe);
                }
                ((BytesColumnVector)outputColumnVector).setRef(outputBatch.size, buffer.getData(), start, length);
                continue;
            }
            ((BytesColumnVector)outputColumnVector).noNulls = false;
            ((BytesColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            inputColumnVector = (DecimalColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (DecimalColumnVector)outputBatch.cols[keyIndex];
            if (((DecimalColumnVector)inputColumnVector).noNulls || !((DecimalColumnVector)inputColumnVector).isNull[0]) {
                ((DecimalColumnVector)outputColumnVector).set(outputBatch.size, ((DecimalColumnVector)inputColumnVector).vector[0]);
                continue;
            }
            ((DecimalColumnVector)outputColumnVector).noNulls = false;
            ((DecimalColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            inputColumnVector = (TimestampColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (TimestampColumnVector)outputBatch.cols[keyIndex];
            if (((TimestampColumnVector)inputColumnVector).noNulls || !((TimestampColumnVector)inputColumnVector).isNull[0]) {
                ((TimestampColumnVector)outputColumnVector).setElement(outputBatch.size, 0, inputColumnVector);
                continue;
            }
            ((TimestampColumnVector)outputColumnVector).noNulls = false;
            ((TimestampColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            inputColumnVector = (IntervalDayTimeColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (IntervalDayTimeColumnVector)outputBatch.cols[keyIndex];
            if (((IntervalDayTimeColumnVector)inputColumnVector).noNulls || !((IntervalDayTimeColumnVector)inputColumnVector).isNull[0]) {
                ((IntervalDayTimeColumnVector)outputColumnVector).setElement(outputBatch.size, 0, inputColumnVector);
                continue;
            }
            ((IntervalDayTimeColumnVector)outputColumnVector).noNulls = false;
            ((IntervalDayTimeColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
    }
}

