/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.postgresql;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.AutoProgressMapper;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.util.Executor;
import org.apache.sqoop.util.JdbcUrl;
import org.apache.sqoop.util.LoggingUtils;
import org.apache.sqoop.util.PostgreSQLUtils;

public class PGBulkloadExportMapper
extends AutoProgressMapper<LongWritable, Writable, LongWritable, Text> {
    private Configuration conf;
    private DBConfiguration dbConf;
    private Process process;
    private OutputStream out;
    protected BufferedWriter writer;
    private Thread thread;
    protected String tmpTableName;
    private String tableName;
    private String passwordFilename;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.conf = context.getConfiguration();
        this.dbConf = new DBConfiguration(this.conf);
        this.tableName = this.dbConf.getOutputTableName();
        this.tmpTableName = this.tableName + "_" + context.getTaskAttemptID().toString();
        Connection conn = null;
        try {
            StringBuffer query;
            conn = this.dbConf.getConnection();
            conn.setAutoCommit(false);
            if (this.conf.getBoolean("pgbulkload.clear.staging.table", false)) {
                query = new StringBuffer();
                query.append("DROP TABLE IF EXISTS ");
                query.append(this.tmpTableName);
                this.doExecuteUpdate(query.toString());
            }
            query = new StringBuffer();
            query.append("CREATE TABLE ");
            query.append(this.tmpTableName);
            query.append("(LIKE ");
            query.append(this.tableName);
            query.append(" INCLUDING CONSTRAINTS)");
            if (this.conf.get("pgbulkload.staging.tablespace") != null) {
                query.append("TABLESPACE ");
                query.append(this.conf.get("pgbulkload.staging.tablespace"));
            }
            this.doExecuteUpdate(query.toString());
            conn.commit();
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unable to load JDBC driver class", (Throwable)ex);
            throw new IOException(ex);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to execute statement", ex);
            throw new IOException(ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to close connection", ex);
            }
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            List<String> envp = Executor.getCurEnvpStrings();
            args.add(this.conf.get("pgbulkload.bin", "pg_bulkload"));
            args.add("--username=" + this.conf.get("mapreduce.jdbc.username"));
            args.add("--dbname=" + JdbcUrl.getDatabaseName(this.conf.get("mapreduce.jdbc.url")));
            args.add("--host=" + JdbcUrl.getHostName(this.conf.get("mapreduce.jdbc.url")));
            int port = JdbcUrl.getPort(this.conf.get("mapreduce.jdbc.url"));
            if (port != -1) {
                args.add("--port=" + port);
            }
            args.add("--input=stdin");
            args.add("--output=" + this.tmpTableName);
            args.add("-o");
            args.add("TYPE=CSV");
            args.add("-o");
            args.add("DELIMITER=" + this.conf.get("pgbulkload.input.field.delim", ","));
            args.add("-o");
            args.add("QUOTE=" + this.conf.get("pgbulkload.input.enclosedby", "\""));
            args.add("-o");
            args.add("ESCAPE=" + this.conf.get("pgbulkload.input.escapedby", "\""));
            args.add("-o");
            args.add("CHECK_CONSTRAINTS=" + this.conf.get("pgbulkload.check.constraints"));
            args.add("-o");
            args.add("PARSE_ERRORS=" + this.conf.get("pgbulkload.parse.errors"));
            args.add("-o");
            args.add("DUPLICATE_ERRORS=" + this.conf.get("pgbulkload.duplicate.errors"));
            if (this.conf.get("pgbulkload.null.string") != null) {
                args.add("-o");
                args.add("NULL=" + this.conf.get("pgbulkload.null.string"));
            }
            if (this.conf.get("pgbulkload.filter") != null) {
                args.add("-o");
                args.add("FILTER=" + this.conf.get("pgbulkload.filter"));
            }
            LOG.debug((Object)"Starting pg_bulkload with arguments:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
            if (this.conf.get("mapreduce.jdbc.password") != null) {
                String tmpDir = System.getProperty("test.build.data", "/tmp/");
                if (!tmpDir.endsWith(File.separator)) {
                    tmpDir = tmpDir + File.separator;
                }
                tmpDir = this.conf.get("job.local.dir", tmpDir);
                this.passwordFilename = PostgreSQLUtils.writePasswordFile(tmpDir, this.conf.get("mapreduce.jdbc.password"));
                envp.add("PGPASSFILE=" + this.passwordFilename);
            }
            this.process = Runtime.getRuntime().exec(args.toArray(new String[0]), envp.toArray(new String[0]));
            this.out = this.process.getOutputStream();
            this.writer = new BufferedWriter(new OutputStreamWriter(this.out));
            this.thread = new ReadThread(this.process.getErrorStream());
            this.thread.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't start up pg_bulkload process", (Throwable)e);
            this.cleanup(context);
            this.doExecuteUpdate("DROP TABLE " + this.tmpTableName);
            throw new IOException(e);
        }
    }

    public void map(LongWritable key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            String str = value.toString();
            if (value instanceof Text) {
                this.writer.write(str, 0, str.length());
                this.writer.newLine();
            } else if (value instanceof SqoopRecord) {
                this.writer.write(str, 0, str.length());
            }
        }
        catch (Exception e) {
            this.doExecuteUpdate("DROP TABLE " + this.tmpTableName);
            this.cleanup(context);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        LongWritable taskid = new LongWritable((long)context.getTaskAttemptID().getTaskID().getId());
        context.write((Object)taskid, (Object)new Text(this.tmpTableName));
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        finally {
            if (null != this.process) {
                while (true) {
                    try {
                        int returnValue = this.process.waitFor();
                        if (returnValue != 0) {
                            throw new RuntimeException("Unexpected return value from pg_bulkload: " + returnValue);
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.debug((Object)"Caught interrupted exception waiting for process pg_bulkload.bin to exit");
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
        }
        if (null != this.passwordFilename && !new File(this.passwordFilename).delete()) {
            LOG.error((Object)("Could not remove postgresql password file " + this.passwordFilename));
            LOG.error((Object)"You should remove this file to protect your credentials.");
        }
    }

    protected int doExecuteUpdate(String query) throws IOException {
        Connection conn = null;
        try {
            conn = this.dbConf.getConnection();
            conn.setAutoCommit(false);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unable to load JDBC driver class", (Throwable)ex);
            throw new IOException(ex);
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to connect to database", ex);
            throw new IOException(ex);
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int ret = stmt.executeUpdate(query);
            conn.commit();
            int n = ret;
            return n;
        }
        catch (SQLException ex) {
            LoggingUtils.logAll(LOG, "Unable to execute query: " + query, ex);
            throw new IOException(ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Unable to close statement", ex);
                }
            }
            try {
                conn.close();
            }
            catch (SQLException ex) {
                LoggingUtils.logAll(LOG, "Unable to close connection", ex);
            }
        }
    }

    private class ReadThread
    extends Thread {
        private InputStream in;

        ReadThread(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

