/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.oozie;

import org.apache.oozie.client.OozieClient;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.impl.shim.oozie.FallbackOozieClientImpl;
import org.pentaho.big.data.impl.shim.oozie.OozieServiceImpl;
import org.pentaho.bigdata.api.oozie.OozieService;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.oozie.shim.api.OozieClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OozieServiceFactoryImpl
implements NamedClusterServiceFactory<OozieService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OozieServiceFactoryImpl.class);
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;

    public OozieServiceFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public Class<OozieService> getServiceClass() {
        return OozieService.class;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        boolean ncState = namedCluster == null || !namedCluster.isUseGateway();
        return this.isActiveConfiguration && ncState;
    }

    public OozieService create(NamedCluster namedCluster) {
        org.pentaho.oozie.shim.api.OozieClient client;
        String oozieUrl = namedCluster.getOozieUrl();
        try {
            OozieClientFactory oozieClientFactory = (OozieClientFactory)this.hadoopConfiguration.getShim(OozieClientFactory.class);
            client = oozieClientFactory.create(oozieUrl);
        }
        catch (ConfigurationException e) {
            client = new FallbackOozieClientImpl(new OozieClient(oozieUrl));
            LOGGER.warn("Could not load OozieClient from the shim.  Falling back to a default implementation. " + namedCluster, (Throwable)e);
        }
        return new OozieServiceImpl(client);
    }
}

