/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.checkdbconnection;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.checkdbconnection.JobEntryCheckDbConnections;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="CHECK_DB_CONNECTIONS", image="CDBC.svg", pluginType=PluginDialog.PluginType.JOBENTRY, documentationUrl="http://wiki.pentaho.com/display/EAI/Check+Db+connections")
public class JobEntryCheckDbConnectionsDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryCheckDbConnectionsDialog.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryCheckDbConnections jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wbdSourceFileFolder;
    private FormData fdbdSourceFileFolder;
    private Button wbgetConnections;
    private FormData fdbgetConnections;
    private String[] connections;

    public JobEntryCheckDbConnectionsDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryCheckDbConnections)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        int rows;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryCheckDbConnectionsDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wName, 2 * margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        this.wbdSourceFileFolder = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbdSourceFileFolder);
        this.wbdSourceFileFolder.setText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.DeleteEntry", (String[])new String[0]));
        this.wbdSourceFileFolder.setToolTipText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.DeleteSourceFileButton.Label", (String[])new String[0]));
        this.fdbdSourceFileFolder = new FormData();
        this.fdbdSourceFileFolder.right = new FormAttachment(100, -margin);
        this.fdbdSourceFileFolder.top = new FormAttachment((Control)this.wlFields, 50);
        this.wbdSourceFileFolder.setLayoutData((Object)this.fdbdSourceFileFolder);
        this.wbgetConnections = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbgetConnections);
        this.wbgetConnections.setText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.GetConnections", (String[])new String[0]));
        this.wbgetConnections.setToolTipText(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.GetConnections.Tooltip", (String[])new String[0]));
        this.fdbgetConnections = new FormData();
        this.fdbgetConnections.right = new FormAttachment(100, -margin);
        this.fdbgetConnections.top = new FormAttachment((Control)this.wlFields, 20);
        this.wbgetConnections.setLayoutData((Object)this.fdbgetConnections);
        this.addDatabases();
        int FieldsRows = rows = this.jobEntry.getConnections() == null ? 1 : (this.jobEntry.getConnections().length == 0 ? 0 : this.jobEntry.getConnections().length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Fields.Argument.Label", (String[])new String[0]), 2, this.connections, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Fields.WaitFor.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Fields.WaitForTime.Label", (String[])new String[0]), 2, JobEntryCheckDbConnections.unitTimeDesc, false)};
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.Fields.Column", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"JobCheckDbConnections.WaitFor.ToolTip", (String[])new String[0]));
        this.wFields = new TableView((VariableSpace)this.jobMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment((Control)this.wbgetConnections, -margin);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData((Object)this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(50, -10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wOK.setLayoutData((Object)fd);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(50, 10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wCancel.setLayoutData((Object)fd);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)margin, (Control)this.wFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCheckDbConnectionsDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCheckDbConnectionsDialog.this.ok();
            }
        };
        this.wbdSourceFileFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = JobEntryCheckDbConnectionsDialog.this.wFields.getSelectionIndices();
                JobEntryCheckDbConnectionsDialog.this.wFields.remove(idx);
                JobEntryCheckDbConnectionsDialog.this.wFields.removeEmptyRows();
                JobEntryCheckDbConnectionsDialog.this.wFields.setRowNums();
            }
        });
        this.wbgetConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JobEntryCheckDbConnectionsDialog.this.getDatabases();
            }
        });
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryCheckDbConnectionsDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryCheckDbConnectionsDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobCheckDbConnectionsDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void addDatabases() {
        this.connections = new String[this.jobMeta.nrDatabases()];
        for (int i = 0; i < this.jobMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.jobMeta.getDatabase(i);
            this.connections[i] = ci.getName();
        }
    }

    public void getDatabases() {
        this.wFields.removeAll();
        for (int i = 0; i < this.jobMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.jobMeta.getDatabase(i);
            if (ci == null) continue;
            this.wFields.add(new String[]{ci.getName(), "0", JobEntryCheckDbConnections.unitTimeDesc[0]});
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        if (this.jobEntry.getConnections() != null) {
            for (int i = 0; i < this.jobEntry.getConnections().length; ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (this.jobEntry.getConnections()[i] == null) continue;
                ti.setText(1, this.jobEntry.getConnections()[i].getName());
                ti.setText(2, "" + Const.toInt((String)this.jobEntry.getWaitfors()[i], (int)0));
                ti.setText(3, JobEntryCheckDbConnections.getWaitTimeDesc((int)this.jobEntry.getWaittimes()[i]));
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        int nritems = this.wFields.nrNonEmpty();
        DatabaseMeta[] connections = new DatabaseMeta[nritems];
        String[] waitfors = new String[nritems];
        int[] waittimes = new int[nritems];
        for (int i = 0; i < nritems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            DatabaseMeta dbMeta = this.jobMeta.findDatabase(arg);
            if (dbMeta == null) continue;
            connections[i] = dbMeta;
            waitfors[i] = "" + Const.toInt((String)this.wFields.getNonEmpty(i).getText(2), (int)0);
            waittimes[i] = JobEntryCheckDbConnections.getWaitTimeByDesc((String)this.wFields.getNonEmpty(i).getText(3));
        }
        this.jobEntry.setConnections(connections);
        this.jobEntry.setWaitfors(waitfors);
        this.jobEntry.setWaittimes(waittimes);
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

