/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.ehcache;

import java.net.URI;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import org.ehcache.jcache.JCacheCachingProvider;
import org.ehcache.jcache.JCacheManager;
import org.pentaho.caching.api.PentahoCacheSystemConfiguration;
import org.pentaho.caching.spi.AbstractCacheProvidingService;

public class EhcacheProvidingService
extends AbstractCacheProvidingService {
    private static final JCacheCachingProvider providerInstance = new JCacheCachingProvider();
    private static CacheManager cacheManager;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private final ThreadFactory threadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            thread.setName("ehcache-jcache");
            thread.setDaemon(true);
            return thread;
        }
    });

    public static CacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = CacheManager.newInstance((Configuration)new Configuration());
        }
        return cacheManager;
    }

    public javax.cache.CacheManager createCacheManager(PentahoCacheSystemConfiguration systemConfiguration) {
        return new JCacheManager(providerInstance, EhcacheProvidingService.getCacheManager(), URI.create(((Object)((Object)this)).getClass().getName()), new Properties()){

            public ExecutorService getExecutorService() {
                return EhcacheProvidingService.this.executorService;
            }
        };
    }

    public void shutdown() {
        try {
            EhcacheProvidingService.getCacheManager().shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }
}

