/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.metrics;

import java.io.Serializable;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.spark.executor.TaskMetrics;

@InterfaceAudience.Private
public class ShuffleReadMetrics
implements Serializable {
    public final long remoteBlocksFetched;
    public final long localBlocksFetched;
    public final long fetchWaitTime;
    public final long remoteBytesRead;
    public final long localBytesRead;
    public final long recordsRead;

    private ShuffleReadMetrics() {
        this(0L, 0L, 0L, 0L, 0L, 0L);
    }

    public ShuffleReadMetrics(long remoteBlocksFetched, long localBlocksFetched, long fetchWaitTime, long remoteBytesRead, long localBytesRead, long recordsRead) {
        this.remoteBlocksFetched = remoteBlocksFetched;
        this.localBlocksFetched = localBlocksFetched;
        this.fetchWaitTime = fetchWaitTime;
        this.remoteBytesRead = remoteBytesRead;
        this.localBytesRead = localBytesRead;
        this.recordsRead = recordsRead;
    }

    public ShuffleReadMetrics(TaskMetrics metrics) {
        this(metrics.shuffleReadMetrics().remoteBlocksFetched(), metrics.shuffleReadMetrics().localBlocksFetched(), metrics.shuffleReadMetrics().fetchWaitTime(), metrics.shuffleReadMetrics().remoteBytesRead(), metrics.shuffleReadMetrics().localBytesRead(), metrics.shuffleReadMetrics().recordsRead());
    }

    public long getTotalBlocksFetched() {
        return this.remoteBlocksFetched + this.localBlocksFetched;
    }

    public String toString() {
        return "ShuffleReadMetrics{remoteBlocksFetched=" + this.remoteBlocksFetched + ", localBlocksFetched=" + this.localBlocksFetched + ", fetchWaitTime=" + this.fetchWaitTime + ", remoteBytesRead=" + this.remoteBytesRead + '}';
    }
}

