/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NotCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsFalse;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="not", value="_FUNC_ a - Logical not")
@VectorizedExpressions(value={NotCol.class, SelectColumnIsFalse.class})
@NDV(maxNdv=2L)
public class GenericUDFOPNot
extends GenericUDF {
    private final BooleanWritable result = new BooleanWritable();
    private transient BooleanObjectInspector boi;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The operator NOT only accepts 1 argument.");
        }
        this.boi = (BooleanObjectInspector)arguments[0];
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object a0 = arguments[0].get();
        if (a0 == null) {
            return null;
        }
        this.result.set(!this.boi.get(a0));
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "(not " + children[0] + ")";
    }
}

