/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterIntervalDayTimeColGreaterEqualIntervalDayTimeScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalDayTime value;

    public FilterIntervalDayTimeColGreaterEqualIntervalDayTimeScalar(int colNum, HiveIntervalDayTime value) {
        this.colNum = colNum;
        this.value = value;
    }

    public FilterIntervalDayTimeColGreaterEqualIntervalDayTimeScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector1 = (IntervalDayTimeColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating) {
                if (inputColVector1.compareTo(0, this.value) < 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inputColVector1.compareTo(i, this.value) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (inputColVector1.compareTo(i, this.value) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating) {
            if (!inputIsNull[0]) {
                if (inputColVector1.compareTo(0, this.value) < 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputIsNull[i] || inputColVector1.compareTo(i, this.value) < 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i] || inputColVector1.compareTo(i, this.value) < 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

