/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FuncRand
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputCol;
    private Random random;

    public FuncRand(long seed, int outputCol) {
        this.outputCol = outputCol;
        this.random = new Random(seed);
    }

    public FuncRand() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputCol];
        int[] sel = batch.selected;
        int n = batch.size;
        double[] outputVector = outputColVector.vector;
        outputColVector.isRepeating = false;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        if (batch.selectedInUse) {
            if (!outputColVector.noNulls) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outputVector[i] = this.random.nextDouble();
                }
            } else {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.random.nextDouble();
                }
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                outputVector[i] = this.random.nextDouble();
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputCol;
    }

    public int getOutputCol() {
        return this.outputCol;
    }

    public void setOutputCol(int outputCol) {
        this.outputCol = outputCol;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

