/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterColOrScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private long value;
    private int colNum;

    public FilterColOrScalar() {
    }

    public FilterColOrScalar(int colNum, long scalarVal) {
        this();
        this.colNum = colNum;
        this.value = scalarVal;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.value == 0L) {
            super.evaluateChildren(batch);
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

