/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncDoubleToDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class CastDoubleToDecimal
extends FuncDoubleToDecimal {
    private static final long serialVersionUID = 1L;

    public CastDoubleToDecimal() {
    }

    public CastDoubleToDecimal(int inputColumn, int outputColumn) {
        super(inputColumn, outputColumn);
    }

    @Override
    protected void func(DecimalColumnVector outV, DoubleColumnVector inV, int i) {
        String s = Double.valueOf(inV.vector[i]).toString();
        HiveDecimal result = HiveDecimal.enforcePrecisionScale(HiveDecimal.create(s), (int)outV.precision, (int)outV.scale);
        HiveDecimalWritable decWritable = outV.vector[i];
        decWritable.set(result);
        if (result == null) {
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.FLOAT).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

