/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticGroup;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.metrics.ShuffleReadMetrics;

public final class SparkMetricsUtils {
    private SparkMetricsUtils() {
    }

    static Map<String, Long> collectMetrics(Metrics allMetrics) {
        LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
        results.put("TaskDurationTime", allMetrics.taskDurationTime);
        results.put("ExecutorCpuTime", allMetrics.executorCpuTime);
        results.put("ExecutorRunTime", allMetrics.executorRunTime);
        results.put("JvmGCTime", allMetrics.jvmGCTime);
        results.put("MemoryBytesSpilled", allMetrics.memoryBytesSpilled);
        results.put("DiskBytesSpilled", allMetrics.diskBytesSpilled);
        results.put("ExecutorDeserializeTime", allMetrics.executorDeserializeTime);
        results.put("ExecutorDeserializeCpuTime", allMetrics.executorDeserializeCpuTime);
        results.put("ResultSize", allMetrics.resultSize);
        results.put("ResultSerializationTime", allMetrics.resultSerializationTime);
        if (allMetrics.inputMetrics != null) {
            results.put("BytesRead", allMetrics.inputMetrics.bytesRead);
            results.put("BytesReadEC", allMetrics.inputMetrics.bytesReadEC);
            results.put("RecordsRead", allMetrics.inputMetrics.recordsRead);
        }
        if (allMetrics.shuffleReadMetrics != null) {
            ShuffleReadMetrics shuffleReadMetrics = allMetrics.shuffleReadMetrics;
            long rbf = shuffleReadMetrics.remoteBlocksFetched;
            long lbf = shuffleReadMetrics.localBlocksFetched;
            results.put("ShuffleTotalBytesRead", shuffleReadMetrics.remoteBytesRead + shuffleReadMetrics.localBytesRead);
            results.put("ShuffleRemoteBytesRead", shuffleReadMetrics.remoteBytesRead);
            results.put("ShuffleLocalBytesRead", shuffleReadMetrics.localBytesRead);
            results.put("ShuffleRecordsRead", shuffleReadMetrics.recordsRead);
            results.put("ShuffleTotalBlocksFetched", rbf + lbf);
            results.put("ShuffleRemoteBlocksFetched", rbf);
            results.put("ShuffleLocalBlocksFetched", lbf);
            results.put("ShuffleFetchWaitTime", shuffleReadMetrics.fetchWaitTime);
        }
        if (allMetrics.shuffleWriteMetrics != null) {
            results.put("ShuffleBytesWritten", allMetrics.shuffleWriteMetrics.shuffleBytesWritten);
            results.put("ShuffleRecordsWritten", allMetrics.shuffleWriteMetrics.shuffleRecordsWritten);
            results.put("ShuffleWriteTime", allMetrics.shuffleWriteMetrics.shuffleWriteTime);
        }
        if (allMetrics.outputMetrics != null) {
            results.put("BytesWritten", allMetrics.outputMetrics.bytesWritten);
            results.put("RecordsWritten", allMetrics.outputMetrics.recordsWritten);
        }
        return results;
    }

    public static long getSparkStatisticAsLong(SparkStatisticGroup group, String name) {
        return Long.parseLong(group.getSparkStatistic(name).getValue());
    }
}

