/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.spark.client.JobHandle;
import org.apache.spark.JobExecutionStatus;

public class RemoteSparkJobMonitor
extends SparkJobMonitor {
    private RemoteSparkJobStatus sparkJobStatus;
    private final HiveConf hiveConf;

    public RemoteSparkJobMonitor(HiveConf hiveConf, RemoteSparkJobStatus sparkJobStatus) {
        super(hiveConf);
        this.sparkJobStatus = sparkJobStatus;
        this.hiveConf = hiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int startMonitor() {
        int rc;
        block19: {
            boolean running = false;
            boolean done = false;
            rc = 0;
            Map<SparkStage, SparkStageProgress> lastProgressMap = null;
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunJob");
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkSubmitToRunning");
            this.startTime = System.currentTimeMillis();
            JobHandle.State state = null;
            try {
                while (true) {
                    try {
                        do {
                            state = this.sparkJobStatus.getRemoteJobState();
                            Preconditions.checkState(this.sparkJobStatus.isRemoteActive(), "Connection to remote Spark driver was lost");
                            switch (state) {
                                case SENT: 
                                case QUEUED: {
                                    long timeCount = (System.currentTimeMillis() - this.startTime) / 1000L;
                                    if (timeCount > this.monitorTimeoutInterval) {
                                        HiveException he = new HiveException(ErrorMsg.SPARK_JOB_MONITOR_TIMEOUT, Long.toString(timeCount));
                                        this.sparkJobStatus.setMonitorError(he);
                                        running = false;
                                        done = true;
                                        rc = 2;
                                    }
                                    if (!LOG.isDebugEnabled()) break;
                                    this.console.printInfo("Spark job state = " + (Object)((Object)state));
                                    break;
                                }
                                case STARTED: {
                                    JobExecutionStatus sparkJobState = this.sparkJobStatus.getState();
                                    if (sparkJobState != JobExecutionStatus.RUNNING) break;
                                    Map<SparkStage, SparkStageProgress> progressMap = this.sparkJobStatus.getSparkStageProgress();
                                    if (!running) {
                                        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkSubmitToRunning");
                                        this.printAppInfo();
                                        this.console.printInfo("Hive on Spark Session Web UI URL: " + this.sparkJobStatus.getWebUIURL());
                                        this.console.printInfo("\nQuery Hive on Spark job[" + this.sparkJobStatus.getJobId() + "] stages: " + Arrays.toString(this.sparkJobStatus.getStageIds()));
                                        this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + "] status = RUNNING");
                                        running = true;
                                        String format = "Job Progress Format\nCurrentTime StageId_StageAttemptId: SucceededTasksCount(+RunningTasksCount-FailedTasksCount)/TotalTasksCount";
                                        if (!this.inPlaceUpdate) {
                                            this.console.printInfo(format);
                                        } else {
                                            this.console.logInfo(format);
                                        }
                                    }
                                    this.printStatus(progressMap, lastProgressMap);
                                    lastProgressMap = progressMap;
                                    break;
                                }
                                case SUCCEEDED: {
                                    Map<SparkStage, SparkStageProgress> progressMap = this.sparkJobStatus.getSparkStageProgress();
                                    this.printStatus(progressMap, lastProgressMap);
                                    lastProgressMap = progressMap;
                                    double duration = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                                    this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + "] finished successfully in " + String.format("%.2f second(s)", duration));
                                    running = false;
                                    done = true;
                                    break;
                                }
                                case FAILED: {
                                    LOG.error("Spark job[" + this.sparkJobStatus.getJobId() + "] failed", this.sparkJobStatus.getSparkJobException());
                                    running = false;
                                    done = true;
                                    rc = 3;
                                    break;
                                }
                                case CANCELLED: {
                                    this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + " was cancelled");
                                    running = false;
                                    done = true;
                                    rc = 3;
                                    break;
                                }
                            }
                            if (done) continue;
                            Thread.sleep(1000L);
                        } while (!done);
                    }
                    catch (Exception e) {
                        Exception finalException = e;
                        if (e instanceof InterruptedException || e instanceof HiveException && e.getCause() instanceof InterruptedException) {
                            finalException = new HiveException(e, ErrorMsg.SPARK_JOB_INTERRUPTED);
                            LOG.warn("Interrupted while monitoring the Hive on Spark application, exiting");
                        } else {
                            String msg = " with exception '" + Utilities.getNameMessage(e) + "' Last known state = " + (state != null ? state.name() : "UNKNOWN");
                            msg = "Failed to monitor Job[" + this.sparkJobStatus.getJobId() + "]" + msg;
                            this.console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
                        }
                        rc = 1;
                        done = true;
                        this.sparkJobStatus.setMonitorError(finalException);
                        if (!done) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (done) break block19;
                throw throwable;
            }
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunJob");
        return rc;
    }

    private void printAppInfo() {
        String appID;
        String sparkMaster = this.hiveConf.get("spark.master");
        if (sparkMaster != null && sparkMaster.startsWith("yarn") && (appID = this.sparkJobStatus.getAppID()) != null) {
            this.console.printInfo("Running with YARN Application = " + appID);
            this.console.printInfo("Kill Command = " + HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.YARNBIN) + " application -kill " + appID);
        }
    }
}

