/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.JobExecutionStatus;

public class LocalSparkJobMonitor
extends SparkJobMonitor {
    private SparkJobStatus sparkJobStatus;

    public LocalSparkJobMonitor(HiveConf hiveConf, SparkJobStatus sparkJobStatus) {
        super(hiveConf);
        this.sparkJobStatus = sparkJobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int startMonitor() {
        int rc;
        block20: {
            boolean running = false;
            boolean done = false;
            rc = 0;
            JobExecutionStatus lastState = null;
            Map<SparkStage, SparkStageProgress> lastProgressMap = null;
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunJob");
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkSubmitToRunning");
            this.startTime = System.currentTimeMillis();
            try {
                while (true) {
                    try {
                        do {
                            JobExecutionStatus state = this.sparkJobStatus.getState();
                            if (LOG.isDebugEnabled()) {
                                this.console.printInfo("state = " + state);
                            }
                            if (state == null) {
                                long timeCount = (System.currentTimeMillis() - this.startTime) / 1000L;
                                if (timeCount > this.monitorTimeoutInterval) {
                                    this.console.printError("Job hasn't been submitted after " + timeCount + "s. Aborting it.");
                                    this.console.printError("Status: " + state);
                                    running = false;
                                    done = true;
                                    rc = 2;
                                    if (done) {
                                        // empty if block
                                    }
                                    break block20;
                                }
                            } else if (state != lastState || state == JobExecutionStatus.RUNNING) {
                                lastState = state;
                                Map<SparkStage, SparkStageProgress> progressMap = this.sparkJobStatus.getSparkStageProgress();
                                switch (state) {
                                    case RUNNING: {
                                        if (!running) {
                                            this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkSubmitToRunning");
                                            this.console.printInfo("\nQuery Hive on Spark job[" + this.sparkJobStatus.getJobId() + "] stages:");
                                            for (int stageId : this.sparkJobStatus.getStageIds()) {
                                                this.console.printInfo(Integer.toString(stageId));
                                            }
                                            this.console.printInfo("\nStatus: Running (Hive on Spark job[" + this.sparkJobStatus.getJobId() + "])");
                                            running = true;
                                            this.console.printInfo("Job Progress Format\nCurrentTime StageId_StageAttemptId: SucceededTasksCount(+RunningTasksCount-FailedTasksCount)/TotalTasksCount [StageCost]");
                                        }
                                        this.printStatus(progressMap, lastProgressMap);
                                        lastProgressMap = progressMap;
                                        break;
                                    }
                                    case SUCCEEDED: {
                                        this.printStatus(progressMap, lastProgressMap);
                                        lastProgressMap = progressMap;
                                        double duration = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                                        this.console.printInfo("Status: Finished successfully in " + String.format("%.2f seconds", duration));
                                        running = false;
                                        done = true;
                                        break;
                                    }
                                    case FAILED: {
                                        this.console.printError("Status: Failed");
                                        running = false;
                                        done = true;
                                        rc = 3;
                                        break;
                                    }
                                    case UNKNOWN: {
                                        this.console.printError("Status: Unknown");
                                        running = false;
                                        done = true;
                                        rc = 4;
                                        break;
                                    }
                                }
                            }
                            if (done) continue;
                            Thread.sleep(1000L);
                        } while (!done);
                    }
                    catch (Exception e) {
                        String msg = " with exception '" + Utilities.getNameMessage(e) + "'";
                        msg = "Failed to monitor Job[ " + this.sparkJobStatus.getJobId() + "]" + msg;
                        LOG.error(msg, (Throwable)e);
                        this.console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
                        rc = 1;
                        done = true;
                        this.sparkJobStatus.setMonitorError(e);
                        if (!done) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (done) break block20;
                throw throwable;
            }
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunJob");
        return rc;
    }
}

