/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.session;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.HiveSparkClientFactory;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionImpl;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.spark.client.SparkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSessionManagerImpl
implements SparkSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SparkSessionManagerImpl.class);
    private final Set<SparkSession> createdSessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile Future<?> timeoutFuture;
    private volatile boolean inited = false;
    private volatile HiveConf conf;
    private static SparkSessionManagerImpl instance;

    public static synchronized SparkSessionManagerImpl getInstance() throws HiveException {
        if (instance == null) {
            instance = new SparkSessionManagerImpl();
        }
        return instance;
    }

    private SparkSessionManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(HiveConf hiveConf) throws HiveException {
        if (!this.inited) {
            SparkSessionManagerImpl sparkSessionManagerImpl = this;
            synchronized (sparkSessionManagerImpl) {
                if (!this.inited) {
                    LOG.info("Setting up the session manager.");
                    this.conf = hiveConf;
                    this.startTimeoutThread();
                    Map<String, String> sparkConf = HiveSparkClientFactory.initiateSparkConf(hiveConf, null);
                    try {
                        SparkClientFactory.initialize(sparkConf);
                        this.inited = true;
                    }
                    catch (IOException e) {
                        throw new HiveException("Error initializing SparkClientFactory", e);
                    }
                }
            }
        }
    }

    @Override
    public SparkSession getSession(SparkSession existingSession, HiveConf conf, boolean doOpen) throws HiveException {
        this.setup(conf);
        if (existingSession != null) {
            if (!existingSession.isOpen() && doOpen) {
                existingSession.open(conf);
                this.createdSessions.add(existingSession);
            }
            return existingSession;
        }
        SparkSessionImpl sparkSession = new SparkSessionImpl();
        if (doOpen) {
            sparkSession.open(conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("New session (%s) is created.", sparkSession.getSessionId()));
        }
        this.createdSessions.add(sparkSession);
        return sparkSession;
    }

    @Override
    public void returnSession(SparkSession sparkSession) throws HiveException {
    }

    @Override
    public void closeSession(SparkSession sparkSession) throws HiveException {
        if (sparkSession == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Closing Spark session (%s).", sparkSession.getSessionId()));
        }
        sparkSession.close();
        this.createdSessions.remove(sparkSession);
    }

    @Override
    public void shutdown() {
        LOG.info("Closing the session manager.");
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.createdSessions.forEach(SparkSession::close);
        this.createdSessions.clear();
        this.inited = false;
        SparkClientFactory.stop();
    }

    private void startTimeoutThread() {
        long sessionTimeout = this.conf.getTimeVar(HiveConf.ConfVars.SPARK_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
        long sessionTimeoutPeriod = this.conf.getTimeVar(HiveConf.ConfVars.SPARK_SESSION_TIMEOUT_PERIOD, TimeUnit.MILLISECONDS);
        ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
        this.timeoutFuture = es.scheduleAtFixedRate(() -> this.createdSessions.stream().filter(sparkSession -> sparkSession.triggerTimeout(sessionTimeout)).forEach(this.createdSessions::remove), 0L, sessionTimeoutPeriod, TimeUnit.MILLISECONDS);
    }

    static {
        ShutdownHookManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                try {
                    if (instance != null) {
                        instance.shutdown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

