/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);

    public static UserGroupInformation getUGI() throws LoginException, IOException {
        String doAs = System.getenv("HADOOP_USER_NAME");
        if (doAs != null && doAs.length() > 0) {
            return UserGroupInformation.createProxyUser((String)doAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        return UserGroupInformation.getCurrentUser();
    }

    public static String getUser() throws IOException {
        try {
            UserGroupInformation ugi = SecurityUtils.getUGI();
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }
}

