/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.api;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import org.pentaho.caching.api.PentahoCacheManager;

public class PentahoCacheTemplateConfiguration {
    private final String description;
    private final ImmutableMap<String, String> properties;
    private final PentahoCacheManager cacheManager;

    public PentahoCacheTemplateConfiguration(String description, Map<String, String> properties, PentahoCacheManager cacheManager) {
        this.description = description;
        this.properties = ImmutableMap.copyOf(properties);
        this.cacheManager = cacheManager;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <K, V> Configuration<K, V> createConfiguration(Class<K> keyType, Class<V> valueType) throws IllegalArgumentException {
        return this.cacheManager.createConfiguration(keyType, valueType, (Map<String, String>)this.properties);
    }

    public <K, V> Cache<K, V> createCache(String cacheName, Class<K> keyType, Class<V> valueType) throws IllegalArgumentException {
        return this.cacheManager.createCache(cacheName, this.createConfiguration(keyType, valueType));
    }

    public PentahoCacheTemplateConfiguration overrideProperties(final Map<String, String> templateOverrides) {
        ImmutableMap overriddenProperties = ImmutableMap.builder().putAll(Maps.filterKeys(this.getProperties(), (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return !templateOverrides.containsKey(s);
            }
        })).putAll(templateOverrides).build();
        return new PentahoCacheTemplateConfiguration(this.getDescription(), (Map<String, String>)overriddenProperties, this.getCacheManager());
    }
}

