/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs.nc;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileProvider;
import org.pentaho.big.data.impl.vfs.hdfs.nc.NamedClusterConfigBuilder;
import org.pentaho.big.data.impl.vfs.hdfs.nc.NamedClusterFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemLocator;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.core.osgi.api.VfsEmbeddedFileSystemCloser;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterProvider
extends HDFSFileProvider
implements VfsEmbeddedFileSystemCloser {
    private MetastoreLocatorOsgi metaStoreService;
    private Map<String, Set<FileSystem>> cacheEntries = Collections.synchronizedMap(new HashMap());

    public NamedClusterProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, FileNameParser fileNameParser, String[] schemes, MetastoreLocatorOsgi metaStore) throws FileSystemException {
        this(hadoopFileSystemLocator, namedClusterService, (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager(), fileNameParser, schemes, metaStore);
    }

    public NamedClusterProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, FileNameParser fileNameParser, String schema, MetastoreLocatorOsgi metaStore) throws FileSystemException {
        this(hadoopFileSystemLocator, namedClusterService, (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager(), fileNameParser, new String[]{schema}, metaStore);
    }

    public NamedClusterProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, DefaultFileSystemManager fileSystemManager, FileNameParser fileNameParser, String[] schemes, MetastoreLocatorOsgi metaStore) throws FileSystemException {
        super(hadoopFileSystemLocator, namedClusterService, fileSystemManager, fileNameParser, schemes);
        this.metaStoreService = metaStore;
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName genericFileName = (GenericFileName)name.getRoot();
        String clusterName = genericFileName.getHostName();
        String path = genericFileName.getPath();
        NamedCluster namedCluster = this.getNamedClusterByName(clusterName, fileSystemOptions);
        try {
            if (namedCluster == null) {
                namedCluster = this.namedClusterService.getClusterTemplate();
            }
            String generatedUrl = namedCluster.processURLsubstitution(path == null ? "" : path, this.getMetastore(clusterName, fileSystemOptions), (VariableSpace)new Variables());
            URI uri = URI.create(generatedUrl);
            return new NamedClusterFileSystem(name, uri, fileSystemOptions, this.hadoopFileSystemLocator.getHadoopFilesystem(namedCluster, uri));
        }
        catch (ClusterInitializationException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return NamedClusterConfigBuilder.getInstance(this.metaStoreService, this.namedClusterService);
    }

    NamedCluster getNamedClusterByName(String clusterNameToResolve, FileSystemOptions fileSystemOptions) throws FileSystemException {
        IMetaStore metaStore = this.getMetastore(clusterNameToResolve, fileSystemOptions);
        NamedCluster namedCluster = null;
        try {
            if (metaStore != null) {
                namedCluster = this.namedClusterService.read(clusterNameToResolve, metaStore);
            }
        }
        catch (MetaStoreException e) {
            throw new FileSystemException((Throwable)e);
        }
        return namedCluster;
    }

    protected synchronized FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fs = this.findFileSystem((Comparable<?>)rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            this.addCacheEntry(rootName, fs);
        }
        return fs;
    }

    private String getFileSystemKey(String rootName, FileSystemOptions fileSystemOptions) {
        return this.getEmbeddedMetastoreKey(fileSystemOptions) == null ? rootName : rootName + this.getEmbeddedMetastoreKey(fileSystemOptions);
    }

    private String getEmbeddedMetastoreKey(FileSystemOptions fileSystemOptions) {
        return ((NamedClusterConfigBuilder)this.getConfigBuilder()).getEmbeddedMetastoreKey(fileSystemOptions);
    }

    private IMetaStore getMetastore(String clusterNameToResolve, FileSystemOptions fileSystemOptions) {
        IMetaStore metaStore;
        String embeddedMetastoreKey = this.getEmbeddedMetastoreKey(fileSystemOptions);
        IMetaStore iMetaStore = metaStore = embeddedMetastoreKey != null ? this.metaStoreService.getMetastore(embeddedMetastoreKey) : this.metaStoreService.getMetastore();
        if (metaStore != null) {
            try {
                if (this.namedClusterService.read(clusterNameToResolve, metaStore) != null) {
                    return metaStore;
                }
            }
            catch (MetaStoreException metaStoreException) {
                // empty catch block
            }
            if (this.metaStoreService.getExplicitMetastore(embeddedMetastoreKey) != null) {
                metaStore = this.metaStoreService.getExplicitMetastore(embeddedMetastoreKey);
            }
        }
        return metaStore;
    }

    private void addCacheEntry(FileName rootName, FileSystem fs) throws FileSystemException {
        this.addFileSystem((Comparable)((Object)this.getFileSystemKey(rootName.toString(), fs.getFileSystemOptions())), fs);
        String embeddedMetastoreKey = this.getEmbeddedMetastoreKey(fs.getFileSystemOptions());
        Set<Object> fsSet = this.cacheEntries.get(embeddedMetastoreKey);
        if (fsSet == null) {
            fsSet = Collections.synchronizedSet(new HashSet());
            this.cacheEntries.put(embeddedMetastoreKey, fsSet);
        }
        fsSet.add(fs);
    }

    public void closeFileSystem(String embeddedMetastoreKey) {
        IMetaStore defaultMetastore = this.metaStoreService.getMetastore();
        IMetaStore embeddedMetastore = this.metaStoreService.getExplicitMetastore(embeddedMetastoreKey);
        if (this.cacheEntries.get(embeddedMetastoreKey) != null) {
            for (FileSystem fs : this.cacheEntries.get(embeddedMetastoreKey)) {
                this.closeFileSystem(fs);
            }
        }
        this.cacheEntries.remove(embeddedMetastoreKey);
        this.namedClusterService.close(defaultMetastore);
        if (defaultMetastore != embeddedMetastore) {
            this.namedClusterService.close(embeddedMetastore);
        }
    }

    protected synchronized FileSystem findFileSystem(Comparable<?> key, FileSystemOptions fileSystemProps) {
        String editedKey = this.getFileSystemKey(key.toString(), fileSystemProps);
        return super.findFileSystem((Comparable)((Object)editedKey), fileSystemProps);
    }
}

