/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileNameParser;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileSystem;
import org.pentaho.bigdata.api.hdfs.HadoopFileSystemLocator;
import org.pentaho.di.core.vfs.KettleVFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFileProvider
extends AbstractOriginatingFileProvider {
    protected static Logger logger = LoggerFactory.getLogger(HDFSFileProvider.class);
    public static final String SCHEME = "hdfs";
    public static final String MAPRFS = "maprfs";
    public static final String ATTR_USER_INFO = "UI";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    public static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.RANDOM_ACCESS_READ));
    protected final HadoopFileSystemLocator hadoopFileSystemLocator;
    protected final NamedClusterService namedClusterService;

    @Deprecated
    public HDFSFileProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService) throws FileSystemException {
        this(hadoopFileSystemLocator, namedClusterService, (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager());
    }

    @Deprecated
    public HDFSFileProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, DefaultFileSystemManager fileSystemManager) throws FileSystemException {
        this(hadoopFileSystemLocator, namedClusterService, fileSystemManager, (FileNameParser)HDFSFileNameParser.getInstance(), new String[]{SCHEME, MAPRFS});
    }

    public HDFSFileProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, FileNameParser fileNameParser, String schema) throws FileSystemException {
        this(hadoopFileSystemLocator, namedClusterService, (DefaultFileSystemManager)KettleVFS.getInstance().getFileSystemManager(), fileNameParser, new String[]{schema});
    }

    public HDFSFileProvider(HadoopFileSystemLocator hadoopFileSystemLocator, NamedClusterService namedClusterService, DefaultFileSystemManager fileSystemManager, FileNameParser fileNameParser, String[] schemes) throws FileSystemException {
        this.hadoopFileSystemLocator = hadoopFileSystemLocator;
        this.namedClusterService = namedClusterService;
        this.setFileNameParser(fileNameParser);
        fileSystemManager.addProvider(schemes, (FileProvider)this);
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName genericFileName = (GenericFileName)name.getRoot();
        String hostName = genericFileName.getHostName();
        int port = genericFileName.getPort();
        NamedCluster namedCluster = this.namedClusterService.getClusterTemplate();
        namedCluster.setHdfsHost(hostName);
        if (port > 0) {
            namedCluster.setHdfsPort(String.valueOf(port));
        } else {
            namedCluster.setHdfsPort("");
        }
        namedCluster.setMapr(MAPRFS.equals(name.getScheme()));
        try {
            return new HDFSFileSystem(name, fileSystemOptions, this.hadoopFileSystemLocator.getHadoopFilesystem(namedCluster, URI.create(name.getURI() == null ? "" : name.getURI())));
        }
        catch (ClusterInitializationException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

