/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.orc.output;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.orc.output.OrcOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class OrcOutputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    private static final Class<?> PKG = OrcOutputMetaBase.class;
    public static final int DEFAULT_ROWS_BETWEEN_ENTRIES = 10000;
    public static final int DEFAULT_STRIPE_SIZE = 64;
    public static final int DEFAULT_COMPRESS_SIZE = 256;
    @Injection(name="FILENAME")
    private String filename;
    @InjectionDeep
    private List<OrcOutputField> outputFields = new ArrayList<OrcOutputField>();
    @Injection(name="OPTIONS_COMPRESSION")
    protected String compressionType = "";
    @Injection(name="OPTIONS_STRIPE_SIZE")
    protected int stripeSize = 64;
    @Injection(name="OPTIONS_COMPRESS_SIZE")
    protected int compressSize = 256;
    @Injection(name="OPTIONS_ROWS_BETWEEN_ENTRIES")
    protected int rowsBetweenEntries = 0;
    @Injection(name="OPTIONS_DATE_IN_FILE_NAME")
    protected boolean dateInFileName = false;
    @Injection(name="OPTIONS_TIME_IN_FILE_NAME")
    protected boolean timeInFileName = false;
    @Injection(name="OPTIONS_DATE_FORMAT")
    protected String dateTimeFormat = "";
    @Injection(name="OVERRIDE_OUTPUT")
    protected boolean overrideOutput;

    public void setDefault() {
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isOverrideOutput() {
        return this.overrideOutput;
    }

    public void setOverrideOutput(boolean overrideOutput) {
        this.overrideOutput = overrideOutput;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<OrcOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<OrcOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    public void setStripeSize(int stripeSize) {
        this.stripeSize = stripeSize;
    }

    public int getCompressSize() {
        return this.compressSize;
    }

    public void setCompressSize(int compressSize) {
        this.compressSize = compressSize;
    }

    public int getRowsBetweenEntries() {
        return this.rowsBetweenEntries;
    }

    public void setRowsBetweenEntries(int rowsBetweenEntries) {
        this.rowsBetweenEntries = rowsBetweenEntries;
    }

    public boolean isDateInFileName() {
        return this.dateInFileName;
    }

    public void setDateInFileName(boolean dateInFileName) {
        this.dateInFileName = dateInFileName;
    }

    public boolean isTimeInFileName() {
        return this.timeInFileName;
    }

    public void setTimeInFileName(boolean timeInFileName) {
        this.timeInFileName = timeInFileName;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<OrcOutputField> orcOutputFields = new ArrayList<OrcOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                OrcOutputField outputField = new OrcOutputField();
                outputField.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                outputField.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                outputField.setFormatType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                outputField.setPrecision(XMLHandler.getTagValue((Node)fnode, (String)"precision"));
                outputField.setScale(XMLHandler.getTagValue((Node)fnode, (String)"scale"));
                outputField.setAllowNull(XMLHandler.getTagValue((Node)fnode, (String)"nullable"));
                outputField.setDefaultValue(XMLHandler.getTagValue((Node)fnode, (String)"default"));
                orcOutputFields.add(outputField);
            }
            this.outputFields = orcOutputFields;
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.overrideOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput"));
            this.compressionType = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.stripeSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"stripeSize"), 10);
            this.compressSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"compressSize"), 10);
            this.rowsBetweenEntries = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"rowsBetweenEntries"), 10);
            this.dateTimeFormat = XMLHandler.getTagValue((Node)stepnode, (String)"dateTimeFormat");
            this.dateInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dateInFileName"));
            this.timeInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"timeInFileName"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overrideOutput", (boolean)this.overrideOutput));
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.compressionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"stripeSize", (int)this.stripeSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"compressSize", (int)this.compressSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowsBetweenEntries", (int)this.rowsBetweenEntries));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateTimeFormat", (String)this.dateTimeFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateInFileName", (boolean)this.dateInFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timeInFileName", (boolean)this.timeInFileName));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.size(); ++i) {
            OrcOutputField field = this.outputFields.get(i);
            if (field.getPentahoFieldName() == null || field.getPentahoFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getFormatFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getPentahoFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (int)field.getOrcType().getId()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"scale", (int)field.getScale()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullable", (boolean)field.getAllowNull()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)field.getDefaultValue()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.overrideOutput = rep.getStepAttributeBoolean(id_step, "overrideOutput");
            this.compressionType = rep.getStepAttributeString(id_step, "compression");
            this.stripeSize = Math.toIntExact(rep.getStepAttributeInteger(id_step, "stripeSize"));
            this.compressSize = Math.toIntExact(rep.getStepAttributeInteger(id_step, "compressSize"));
            this.rowsBetweenEntries = Math.toIntExact(rep.getStepAttributeInteger(id_step, "rowsBetweenEntries"));
            this.dateTimeFormat = rep.getStepAttributeString(id_step, "dateTimeFormat");
            this.dateInFileName = rep.getStepAttributeBoolean(id_step, "dateInFileName");
            this.timeInFileName = rep.getStepAttributeBoolean(id_step, "timeInFileName");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            ArrayList<OrcOutputField> orcOutputFields = new ArrayList<OrcOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                OrcOutputField outputField = new OrcOutputField();
                outputField.setFormatFieldName(rep.getStepAttributeString(id_step, i, "path"));
                outputField.setPentahoFieldName(rep.getStepAttributeString(id_step, i, "name"));
                outputField.setFormatType(rep.getStepAttributeString(id_step, i, "type"));
                outputField.setPrecision(rep.getStepAttributeString(id_step, i, "precision"));
                outputField.setScale(rep.getStepAttributeString(id_step, i, "scale"));
                outputField.setAllowNull(rep.getStepAttributeString(id_step, i, "nullable"));
                outputField.setDefaultValue(rep.getStepAttributeString(id_step, i, "default"));
                orcOutputFields.add(outputField);
            }
            this.outputFields = orcOutputFields;
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "overrideOutput", this.overrideOutput);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.compressionType);
            rep.saveStepAttribute(id_transformation, id_step, "stripeSize", (long)this.stripeSize);
            rep.saveStepAttribute(id_transformation, id_step, "compressSize", (long)this.compressSize);
            rep.saveStepAttribute(id_transformation, id_step, "rowsBetweenEntries", (long)this.rowsBetweenEntries);
            rep.saveStepAttribute(id_transformation, id_step, "dateTimeFormat", this.dateTimeFormat);
            rep.saveStepAttribute(id_transformation, id_step, "dateInFileName", this.dateInFileName);
            rep.saveStepAttribute(id_transformation, id_step, "timeInFileName", this.timeInFileName);
            for (int i = 0; i < this.outputFields.size(); ++i) {
                OrcOutputField field = this.outputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getFormatFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getPentahoFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", (long)field.getOrcType().getId());
                rep.saveStepAttribute(id_transformation, id_step, i, "precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "scale", (long)field.getScale());
                rep.saveStepAttribute(id_transformation, id_step, i, "nullable", field.getAllowNull());
                rep.saveStepAttribute(id_transformation, id_step, i, "default", field.getDefaultValue());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                FileObject fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getCompressionType() {
        return StringUtil.isVariable((String)this.compressionType) ? this.compressionType : this.getCompressionType(null).toString();
    }

    public void setCompressionType(String value) {
        this.compressionType = StringUtil.isVariable((String)value) ? value : OrcOutputMetaBase.parseFromToString(value, CompressionType.values(), CompressionType.NONE).name();
    }

    public CompressionType getCompressionType(VariableSpace vspace) {
        return this.parseReplace(this.compressionType, vspace, str -> this.findCompressionType((String)str), CompressionType.NONE);
    }

    public String[] getCompressionTypes() {
        return OrcOutputMetaBase.getStrings(CompressionType.values());
    }

    private CompressionType findCompressionType(String str) {
        try {
            return CompressionType.valueOf(str);
        }
        catch (Throwable th) {
            return OrcOutputMetaBase.parseFromToString(str, CompressionType.values(), CompressionType.NONE);
        }
    }

    protected static <T> String[] getStrings(T[] objects) {
        String[] names = new String[objects.length];
        int i = 0;
        for (T obj : objects) {
            names[i++] = obj.toString();
        }
        return names;
    }

    protected static <T> T parseFromToString(String str, T[] values, T defaultValue) {
        if (!Utils.isEmpty((CharSequence)str)) {
            for (T type : values) {
                if (!str.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
        }
        return defaultValue;
    }

    private <T> T parseReplace(String value, VariableSpace vspace, Function<String, T> parser, T defaultValue) {
        String replaced;
        String string = replaced = vspace != null ? vspace.environmentSubstitute(value) : value;
        if (!Utils.isEmpty((CharSequence)replaced)) {
            try {
                return parser.apply(replaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String constructOutputFilename() {
        String outputFileName = this.filename;
        if (this.dateTimeFormat != null && !this.dateTimeFormat.isEmpty()) {
            String dateTimeFormatPattern = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.dateTimeFormat);
            outputFileName = outputFileName + new SimpleDateFormat(dateTimeFormatPattern).format(new Date());
        } else {
            if (this.dateInFileName) {
                outputFileName = outputFileName + '_' + new SimpleDateFormat("yyyyMMdd").format(new Date());
            }
            if (this.timeInFileName) {
                outputFileName = outputFileName + '_' + new SimpleDateFormat("HHmmss").format(new Date());
            }
        }
        return outputFileName;
    }

    private static String getMsg(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    static /* synthetic */ String access$000(String x0) {
        return OrcOutputMetaBase.getMsg(x0);
    }

    protected static class FieldNames {
        public static final String FILE_NAME = "filename";
        public static final String OVERRIDE_OUTPUT = "overrideOutput";
        public static final String COMPRESSION = "compression";
        public static final String COMPRESS_SIZE = "compressSize";
        public static final String INLINE_INDEXES = "inlineIndexes";
        public static final String ROWS_BETWEEN_ENTRIES = "rowsBetweenEntries";
        public static final String DATE_IN_FILE_NAME = "dateInFileName";
        public static final String TIME_IN_FILE_NAME = "timeInFileName";
        public static final String DATE_FORMAT = "dateTimeFormat";
        public static final String STRIPE_SIZE = "stripeSize";

        protected FieldNames() {
        }
    }

    public static enum CompressionType {
        NONE(OrcOutputMetaBase.access$000("OrcOutput.CompressionType.NONE")),
        ZLIB(OrcOutputMetaBase.access$000("OrcOutput.CompressionType.ZLIB")),
        LZO(OrcOutputMetaBase.access$000("OrcOutput.CompressionType.LZO")),
        SNAPPY(OrcOutputMetaBase.access$000("OrcOutput.CompressionType.SNAPPY"));

        private final String name;

        private CompressionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

