/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.messages.Messages;

public class UploadFileUtils {
    private static final long MAX_FILE_SIZE = 10000000L;
    private static final long MAX_FOLDER_SIZE = 500000000L;
    private static final long MAX_TMP_FOLDER_SIZE = 500000000L;
    private static final String DEFAULT_EXTENSIONS = "csv,dat,txt,tar,zip,tgz,gz,gzip";
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;
    private static final char DOT = '.';
    private static final String DOT_TMP = ".tmp";
    private String fileName;
    private boolean shouldUnzip;
    private boolean temporary;
    private Writer writer;
    private FileItem uploadedItem;
    private IPentahoSession session;
    private long maxFileSize;
    private long maxFolderSize;
    private long maxTmpFolderSize;
    private String relativePath;
    private String path;
    private File pathDir;
    private File tmpPathDir;
    private Set<String> allowedExtensions;
    private String allowedExtensionsString;
    private boolean allowsNoExtension;

    public UploadFileUtils(IPentahoSession sessionValue) {
        this.session = sessionValue;
        this.relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String maxFileLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-file-limit", (String)String.valueOf(10000000L));
        String maxFolderLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-folder-limit", (String)String.valueOf(500000000L));
        String maxTmpFolderLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-tmp-folder-limit", (String)String.valueOf(500000000L));
        String tmpAllowedExtensions = PentahoSystem.getSystemSetting((String)"file-upload-defaults/allowed-extensions", (String)DEFAULT_EXTENSIONS);
        this.setAllowedExtensionsString(tmpAllowedExtensions);
        String allowsNoExtensionString = PentahoSystem.getSystemSetting((String)"file-upload-defaults/allow-files-without-extension", (String)"true");
        this.allowsNoExtension = Boolean.valueOf(allowsNoExtensionString);
        this.maxFileSize = Long.parseLong(maxFileLimit);
        this.maxFolderSize = Long.parseLong(maxFolderLimit);
        this.maxTmpFolderSize = Long.parseLong(maxTmpFolderLimit);
    }

    protected boolean checkExtension(String extension, boolean emitMessage) throws IOException {
        if (null == extension) {
            if (emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            }
            return false;
        }
        if (extension.isEmpty()) {
            if (!this.allowsNoExtension && emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            }
            return this.allowsNoExtension;
        }
        if (!this.allowedExtensions.contains(extension)) {
            if (emitMessage) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0011_ILLEGAL_FILE_TYPE", new Object[]{this.allowedExtensionsString}));
            }
            return false;
        }
        return true;
    }

    public boolean process() throws Exception {
        this.path = PentahoSystem.getApplicationContext().getSolutionPath(this.relativePath);
        this.pathDir = new File(this.path);
        if (!this.pathDir.exists()) {
            this.pathDir.mkdirs();
        }
        this.tmpPathDir = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/tmp"));
        if (!this.tmpPathDir.exists()) {
            this.tmpPathDir.mkdirs();
        }
        if (!this.checkLimits(this.getUploadedFileItem().getSize())) {
            return false;
        }
        if (this.fileName == null) {
            this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0010_FILE_NAME_INVALID"));
            return false;
        }
        if (!this.checkExtension(FilenameUtils.getExtension((String)this.fileName), true)) {
            return false;
        }
        boolean res = this.process(this.getUploadedFileItem().getInputStream());
        this.getUploadedFileItem().delete();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return false;
        }
        File file = null;
        if (this.isTemporary()) {
            String extension = this.getUploadedFileItem() != null ? '.' + this.removeFileName(this.getUploadedFileItem().getName()) + DOT_TMP : DOT_TMP;
            file = PentahoSystem.getApplicationContext().createTempFile(this.session, "", extension, true);
        } else {
            String relPath;
            file = new File(this.getPath() + File.separatorChar + this.fileName);
            String cp = file.getCanonicalPath();
            if (!cp.startsWith(relPath = this.getPathDir().getCanonicalPath())) {
                this.getWriter().write(Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0008_FILE_LOCATION_INVALID"));
                return false;
            }
        }
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (this.shouldUnzip && this.getUploadedFileItem() != null) {
            return this.handleUnzip(file);
        }
        this.writer.write(file.getName());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean handleUnzip(File file) throws IOException {
        String fileNames;
        block12: {
            ITempFileDeleter fileDeleter;
            fileNames = file.getName();
            if (this.session != null && (fileDeleter = (ITempFileDeleter)this.session.getAttribute("PENTAHO_TMP_DELETER")) != null) {
                fileDeleter.trackTempFile(file);
            }
            String extension = FilenameUtils.getExtension((String)this.getUploadedFileItem().getName().toLowerCase());
            String contentType = this.getUploadedFileItem().getContentType();
            if ("zip".equals(extension) || "application/zip".equals(contentType)) {
                if (!this.checkLimits(this.getUncompressedZipFileSize(file), true)) {
                    file.delete();
                    return false;
                }
                fileNames = this.handleZip(file);
            } else {
                if ("tgz".equals(extension) || this.getUploadedFileItem().getName().toLowerCase().endsWith(".tar.gz") || "application/x-compressed".equals(contentType) || "application/tgz".equals(contentType)) {
                    long tarSize = this.getUncompressedGZipFileSize(file);
                    if (this.checkLimits(tarSize, true) && (this.isTemporary() || this.checkLimits(tarSize * 2L, true))) {
                        fileNames = this.handleTarGZ(file);
                        break block12;
                    } else {
                        file.delete();
                        return false;
                    }
                }
                if ("gzip".equals(extension) || "gz".equals(extension)) {
                    if (!this.checkLimits(this.getUncompressedGZipFileSize(file), true)) {
                        file.delete();
                        return false;
                    }
                    fileNames = this.handleGZip(file, false);
                } else if ("tar".equals(extension) || "application/x-tar".equals(contentType)) {
                    if (!this.isTemporary() && !this.checkLimits(this.getUploadedFileItem().getSize(), true)) {
                        file.delete();
                        return false;
                    }
                    fileNames = this.handleTar(file);
                }
            }
        }
        this.writer.write(fileNames);
        return true;
    }

    private long getUncompressedZipFileSize(File theFile) throws IOException {
        long rtn = 0L;
        try (ZipFile zf = new ZipFile(theFile);){
            Enumeration<? extends ZipEntry> zfEntries = zf.entries();
            ZipEntry ze = null;
            while (zfEntries.hasMoreElements()) {
                ze = zfEntries.nextElement();
                rtn += ze.getSize();
            }
        }
        return rtn;
    }

    private long getUncompressedGZipFileSize(File theFile) throws IOException {
        long rtn = 0L;
        try (RandomAccessFile gzipFile = new RandomAccessFile(theFile, "r");){
            gzipFile.seek(gzipFile.length() - 4L);
            byte[] intelSize = new byte[4];
            gzipFile.read(intelSize);
            rtn = (long)((intelSize[3] & 0xFF) << 24 | ((intelSize[2] & 0xFF) << 16) + ((intelSize[1] & 0xFF) << 8) + (intelSize[0] & 0xFF)) & 0xFFFFFFFFL;
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleZip(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fileStream = new FileInputStream(file);
        try {
            ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(fileStream));
            try {
                ZipEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    if (!(entry.isDirectory() || entry.getName().startsWith(".") || entry.getName().startsWith("__MACOSX/"))) {
                        File entryFile = null;
                        String extension = FilenameUtils.getExtension((String)entry.getName());
                        if (this.checkExtension(extension, false)) {
                            entryFile = this.isTemporary() ? PentahoSystem.getApplicationContext().createTempFile(this.session, "", '.' + extension + DOT_TMP, true) : new File(this.getPath() + File.separatorChar + entry.getName());
                            if (sb.length() > 0) {
                                sb.append('\n');
                            }
                            sb.append(entryFile.getName());
                            FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                            try {
                                IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                            }
                            finally {
                                IOUtils.closeQuietly((OutputStream)entryOutputStream);
                            }
                        }
                    }
                    entry = zipStream.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0012_ILLEGAL_CONTENTS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleGZip(File file, boolean fullPath) throws IOException {
        FileInputStream fileStream = new FileInputStream(file);
        try {
            String string;
            String extension;
            String gzFile = file.getCanonicalPath();
            if (FilenameUtils.isExtension((String)gzFile, (String)"tmp")) {
                gzFile = FilenameUtils.removeExtension((String)gzFile);
            }
            if (!this.checkExtension(extension = FilenameUtils.getExtension((String)(gzFile = FilenameUtils.removeExtension((String)gzFile))), true)) {
                String string2 = "";
                return string2;
            }
            File entryFile = null;
            if (this.isTemporary() || fullPath) {
                entryFile = PentahoSystem.getApplicationContext().createTempFile(this.session, "", '.' + extension + DOT_TMP, true);
            } else if (!extension.isEmpty()) {
                entryFile = new File(extension);
            } else {
                File parentFolder = file.getParentFile();
                entryFile = File.createTempFile("upload_gzip", DOT_TMP, parentFolder);
            }
            GZIPInputStream zipStream = new GZIPInputStream(new BufferedInputStream(fileStream));
            try {
                FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                try {
                    IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)entryOutputStream);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
            if (fullPath) {
                string = entryFile.getCanonicalPath();
                return string;
            }
            string = entryFile.getName();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleTar(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fileStream = new FileInputStream(file);
        try {
            TarInputStream zipStream = new TarInputStream((InputStream)new BufferedInputStream(fileStream));
            try {
                TarEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    if (!(entry.isDirectory() || entry.getName().startsWith(".") || entry.getName().startsWith("__MACOSX/"))) {
                        File entryFile = null;
                        String extension = FilenameUtils.getExtension((String)entry.getName());
                        if (this.checkExtension(extension, false)) {
                            entryFile = this.isTemporary() ? PentahoSystem.getApplicationContext().createTempFile(this.session, "", '.' + extension + DOT_TMP, true) : new File(this.getPath() + File.separatorChar + entry.getName());
                            if (sb.length() > 0) {
                                sb.append('\n');
                            }
                            sb.append(entryFile.getName());
                            FileOutputStream entryOutputStream = new FileOutputStream(entryFile);
                            try {
                                IOUtils.copy((InputStream)zipStream, (OutputStream)entryOutputStream);
                            }
                            finally {
                                IOUtils.closeQuietly((OutputStream)entryOutputStream);
                            }
                        }
                    }
                    entry = zipStream.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zipStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileStream);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0012_ILLEGAL_CONTENTS");
    }

    protected String handleTarGZ(File file) throws IOException {
        ITempFileDeleter fileDeleter;
        String filename = this.handleGZip(file, true);
        File tarFile = new File(filename);
        if (this.session != null && (fileDeleter = (ITempFileDeleter)this.session.getAttribute("PENTAHO_TMP_DELETER")) != null) {
            fileDeleter.trackTempFile(tarFile);
        }
        return this.handleTar(tarFile);
    }

    public boolean checkLimits(long itemSize) throws IOException {
        return this.checkLimits(itemSize, false);
    }

    public boolean checkLimits(long itemSize, boolean compressed) throws IOException {
        long folderLimit;
        File checkDir;
        if (itemSize > this.maxFileSize) {
            String error = compressed ? Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0006_FILE_TOO_BIG") : Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0003_FILE_TOO_BIG");
            this.writer.write(error);
            return false;
        }
        if (!this.isTemporary()) {
            checkDir = this.pathDir;
            folderLimit = this.maxFolderSize;
        } else {
            checkDir = this.tmpPathDir;
            folderLimit = this.maxTmpFolderSize;
        }
        long actualDirSize = this.getFolderSize(checkDir);
        if (itemSize + actualDirSize > folderLimit) {
            String error = compressed ? Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0007_FOLDER_SIZE_LIMIT_REACHED") : Messages.getInstance().getErrorString("UploadFileServlet.ERROR_0004_FOLDER_SIZE_LIMIT_REACHED");
            this.writer.write(error);
            return false;
        }
        return true;
    }

    private long getFolderSize(File folder) {
        long foldersize = 0L;
        if (folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) {
                    foldersize += this.getFolderSize(file);
                    continue;
                }
                foldersize += file.length();
            }
        }
        return foldersize;
    }

    protected String removeFileName(String filename) {
        if (null != filename) {
            int len;
            int dotIndex = filename.indexOf(46);
            if (0 < dotIndex && (len = filename.length()) > ++dotIndex) {
                return filename.substring(dotIndex).replaceAll("[^a-zA-Z0-9_.-]", "_");
            }
            return "";
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        this.fileName = value;
    }

    public boolean isShouldUnzip() {
        return this.shouldUnzip;
    }

    public void setShouldUnzip(boolean value) {
        this.shouldUnzip = value;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean value) {
        this.temporary = value;
    }

    public void setWriter(Writer value) {
        this.writer = value;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setUploadedFileItem(FileItem value) {
        this.uploadedItem = value;
    }

    public FileItem getUploadedFileItem() {
        return this.uploadedItem;
    }

    public String getPath() {
        return this.path;
    }

    public File getPathDir() {
        return this.pathDir;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    void setAllowsNoExtension(boolean value) {
        this.allowsNoExtension = value;
    }

    boolean getAllowsNoExtension() {
        return this.allowsNoExtension;
    }

    void setAllowedExtensionsString(String value) {
        this.allowedExtensionsString = value;
        String[] extensions = value.split(",");
        HashSet<String> theSet = new HashSet<String>(extensions.length);
        Collections.addAll(theSet, extensions);
        this.allowedExtensions = theSet;
    }

    String getAllowedExtensionsString() {
        return this.allowedExtensionsString;
    }
}

