/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class ProxyServlet
extends ServletBase {
    private static final long serialVersionUID = 4680027723733552639L;
    private static final Log logger = LogFactory.getLog(ProxyServlet.class);
    private String proxyURL = null;
    private String errorURL = null;

    @Override
    public Log getLogger() {
        return logger;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.proxyURL = servletConfig.getInitParameter("ProxyURL");
        if (this.proxyURL == null) {
            this.error(Messages.getInstance().getString("ProxyServlet.ERROR_0001_NO_PROXY_URL_SPECIFIED"));
        } else {
            try {
                URL url = new URL(this.proxyURL.trim());
                this.info(Messages.getInstance().getString("ProxyServlet.INFO_0001_URL_SELECTED", new Object[]{url.toExternalForm()}));
            }
            catch (Throwable t) {
                this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0002_INVALID_URL", new Object[]{this.proxyURL}));
                this.proxyURL = null;
            }
        }
        this.errorURL = servletConfig.getInitParameter("ErrorURL");
        super.init(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doProxy(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block23: {
            if (this.proxyURL == null) {
                return;
            }
            servletPath = request.getServletPath();
            PentahoSystem.systemEntryPoint();
            theUrl = this.proxyURL + servletPath;
            trustUserParam = "_TRUST_USER_";
            try {
                uriBuilder = new URIBuilder(theUrl);
                queryParams = uriBuilder.getQueryParams();
                for (NameValuePair nameValuePair : queryParams) {
                    if (!nameValuePair.getName().equals(trustUserParam)) continue;
                    queryParams.remove(nameValuePair);
                }
                paramMap = request.getParameterMap();
                for (Map.Entry<K, V> entry : paramMap.entrySet()) {
                    for (String element : array = (String[])entry.getValue()) {
                        queryParams.add(new BasicNameValuePair((String)entry.getKey(), element));
                    }
                }
                userSession = this.getPentahoSession(request);
                name = userSession.getName();
                if (StringUtils.isNotEmpty((String)name)) {
                    queryParams.add(new BasicNameValuePair(trustUserParam, name));
                } else if (this.errorURL != null && this.errorURL.trim().length() > 0) {
                    response.sendRedirect(this.errorURL);
                    break block23;
                }
                ** GOTO lbl-1000
            }
            catch (URISyntaxException e) {
                this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0006_URI_SYNTAX_EXCEPTION", new Object[]{theUrl}));
                e.printStackTrace();
                return;
            }
        }
        PentahoSystem.systemExitPoint();
        return;
lbl-1000:
        // 2 sources

        {
            uriBuilder.setParameters(queryParams);
            this.debug(Messages.getInstance().getString("ProxyServlet.DEBUG_0001_OUTPUT_URL", new Object[]{uriBuilder.toString()}));
            method = new HttpPost(uriBuilder.build());
            client = HttpClientManager.getInstance().createDefaultClient();
            httpResponse = client.execute((HttpUriRequest)method);
            statusLine = httpResponse.getStatusLine();
            statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0003_REMOTE_HTTP_CALL_FAILED", new Object[]{statusLine.toString()}));
            }
            {
                catch (IOException e) {
                    this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0005_TRANSPORT_FAILURE"), e);
                    e.printStackTrace();
                    return;
                }
                {
                    this.setHeader("Content-Type", (HttpRequestBase)method, response);
                    this.setHeader("Content-Length", (HttpRequestBase)method, response);
                    inStr = httpResponse.getEntity().getContent();
                    outStr = response.getOutputStream();
                    buf = new byte[2048];
                    while (-1 != (inCnt = inStr.read(buf))) {
                        outStr.write(buf, 0, inCnt);
                    }
                }
                method.releaseConnection();
                return;
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    private void setHeader(String headerStr, HttpRequestBase method, HttpServletResponse response) {
        Header header = method.getHeaders(headerStr)[0];
        if (header != null) {
            response.setHeader(headerStr, header.getValue());
        }
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }
}

