/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.encoder.Encode;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.web.servlet.IUploadFileServletPlugin;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.safehaus.uuid.UUID;

public class PluggableUploadFileServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -1575521113175397124L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            IUploadFileServletPlugin uploaderPlugin = this.getUploaderBean(this.getDispatchKey(request), response);
            if (uploaderPlugin == null) {
                return;
            }
            response.setContentType("text/plain");
            FileItem uploadItem = this.getFileItem(request, uploaderPlugin.getMaxFileSize());
            if (uploadItem == null) {
                response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0001_NO_FILE_TO_UPLOAD"));
                return;
            }
            String path = PentahoSystem.getApplicationContext().getSolutionPath(uploaderPlugin.getTargetFolder());
            File pathDir = new File(path);
            if (!pathDir.exists()) {
                pathDir.mkdirs();
            }
            if (uploadItem.getSize() + this.getFolderSize(pathDir) > uploaderPlugin.getMaxFolderSize()) {
                response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0004_FOLDER_SIZE_LIMIT_REACHED"));
                return;
            }
            UUID id = UUIDUtil.getUUID();
            String filename = id.toString() + uploaderPlugin.getFileExtension();
            File outFile = new File(path, filename);
            if (this.doesFileExists(outFile)) {
                response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0002_FILE_ALREADY_EXIST"));
                return;
            }
            InputStream fileInputStream = uploadItem.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(outFile);
            try {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            uploaderPlugin.onSuccess(outFile.getAbsolutePath(), response);
        }
        catch (Exception e) {
            response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0005_UNKNOWN_ERROR", new Object[]{e.getLocalizedMessage()}));
        }
    }

    protected IUploadFileServletPlugin getUploaderBean(String uploaderBeanId, HttpServletResponse response) throws PluginBeanException, IOException {
        if (StringUtils.isEmpty((String)uploaderBeanId)) {
            response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0006_NO_UPLOADER_FOUND"));
            return null;
        }
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (!pluginManager.isBeanRegistered(uploaderBeanId)) {
            response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0008_NO_UPLOADER_BY_ID", new Object[]{Encode.forHtml((String)uploaderBeanId)}));
            return null;
        }
        Object uploaderBean = pluginManager.getBean(uploaderBeanId);
        if (!(uploaderBean instanceof IUploadFileServletPlugin)) {
            response.getWriter().write(Messages.getInstance().getErrorString("PluggableUploadFileServlet.ERROR_0007_UPLOADER_WRONG_TYPE", new Object[]{IUploadFileServletPlugin.class.getName()}));
            return null;
        }
        IUploadFileServletPlugin uploaderPlugin = (IUploadFileServletPlugin)uploaderBean;
        return uploaderPlugin;
    }

    private FileItem getFileItem(HttpServletRequest request, long maxFileSize) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax(maxFileSize);
        List items = upload.parseRequest(request);
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            return item;
        }
        return null;
    }

    private long getFolderSize(File folder) {
        long foldersize = 0L;
        File[] filelist = folder.listFiles();
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isDirectory()) {
                foldersize += this.getFolderSize(filelist[i]);
                continue;
            }
            foldersize += filelist[i].length();
        }
        return foldersize;
    }

    private boolean doesFileExists(File file) {
        return file.exists();
    }

    public String getDispatchKey(HttpServletRequest request) {
        String requestPathInfo = request.getPathInfo();
        if (requestPathInfo.startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        return requestPathInfo;
    }
}

