/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class JAXRSPluginServlet
extends SpringServlet
implements ApplicationContextAware {
    private static final long serialVersionUID = 457538570048660945L;
    private static final String APPLICATION_WADL = "application.wadl";
    static final int UNDER_KNOWN_ERROR_RANGE = 399;
    static final int OVER_KNOWN_ERROR_RANGE = 600;
    private static final Pattern WADL_PATTERN = Pattern.compile("(.*)application.wadl(/[A-Za-z0-9_]+(.xsd)+)*");
    private ApplicationContext applicationContext;
    public static final ThreadLocal requestThread = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(JAXRSPluginServlet.class);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ConfigurableApplicationContext getContext() {
        return (ConfigurableApplicationContext)this.applicationContext;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug((Object)("servicing request for resource " + request.getPathInfo()));
        if (WADL_PATTERN.matcher(request.getPathInfo()).find()) {
            final HttpServletRequest originalRequest = request;
            final String appWadlUrl = request.getPathInfo().substring(request.getPathInfo().indexOf(APPLICATION_WADL), request.getPathInfo().length());
            request = (HttpServletRequest)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getPathInfo")) {
                        return appWadlUrl;
                    }
                    if (method.getName().equals("getRequestURL")) {
                        String url = originalRequest.getRequestURL().toString();
                        return new StringBuffer(url.substring(0, url.indexOf(originalRequest.getPathInfo())) + "/" + appWadlUrl);
                    }
                    if (method.getName().equals("getRequestURI")) {
                        String uri = originalRequest.getRequestURI();
                        return uri.substring(0, uri.indexOf(originalRequest.getPathInfo())) + "/" + appWadlUrl;
                    }
                    return method.invoke((Object)originalRequest, args);
                }
            });
            if (originalRequest.getRequestURL() != null) {
                requestThread.set(originalRequest.getRequestURL().toString());
            } else if (originalRequest.getRequestURI() != null) {
                requestThread.set(originalRequest.getRequestURI().toString());
            }
        }
        super.service(request, response);
        if (!response.isCommitted() && response.getStatus() > 399 && response.getStatus() < 600) {
            response.sendError(response.getStatus());
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        if (logger.isDebugEnabled()) {
            rc.getFeatures().put("com.sun.jersey.config.feature.Trace", true);
            rc.getFeatures().put("com.sun.jersey.config.feature.TracePerRequest", true);
        }
        super.initiate(rc, wa);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        props.put("com.sun.jersey.config.property.WadlGeneratorConfig", "org.pentaho.platform.web.servlet.PentahoWadlGeneratorConfig");
        return super.getDefaultResourceConfig(props, webConfig);
    }
}

