/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.session;

import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.system.BaseSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PentahoHttpSession
extends BaseSession {
    private static final long serialVersionUID = 1500696455420691764L;
    private HttpSession session;
    private long authenticationTime = 0L;
    private static final Log logger = LogFactory.getLog(PentahoHttpSession.class);

    public Log getLogger() {
        return logger;
    }

    public PentahoHttpSession(String userName, HttpSession session, Locale locale, IPentahoSession userSession) {
        super(userName, session.getId(), locale);
        this.session = session;
        PentahoSessionParameterProvider sessionParameters = new PentahoSessionParameterProvider(userSession);
        PentahoSystem.sessionStartup((IPentahoSession)this, (IParameterProvider)sessionParameters);
    }

    public Iterator getAttributeNames() {
        return new EnumerationIterator(this.session.getAttributeNames());
    }

    public Object getAttribute(String attributeName) {
        return this.session.getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        this.session.setAttribute(attributeName, value);
    }

    public Object removeAttribute(String attributeName) {
        Object result = this.getAttribute(attributeName);
        this.session.removeAttribute(attributeName);
        return result;
    }

    public void setAuthenticated(String name) {
        super.setAuthenticated(name);
        this.authenticationTime = System.currentTimeMillis();
    }

    public void destroy() {
        if (!"anonymousUser".equals(this.getName())) {
            AuditHelper.audit((String)this.getId(), (String)this.getName(), (String)this.getActionName(), (String)this.getObjectName(), (String)"", (String)"session_end", (String)"", (String)"", (float)((float)(System.currentTimeMillis() - this.authenticationTime) / 1000.0f), null);
        }
        super.destroy();
    }
}

