/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;

public class UsernameSubstringPreAuthenticatedProcessingFilter
extends J2eePreAuthenticatedProcessingFilter {
    private static final Log logger = LogFactory.getLog(UsernameSubstringPreAuthenticatedProcessingFilter.class);
    public static final String PENTAHO_ORIG_USER_PRINCIPAL = "PENTAHO_ORIG_USER_PRINCIPAL";
    private Pattern pattern;

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
        String username = httpRequest.getUserPrincipal() == null ? null : httpRequest.getUserPrincipal().getName();
        logger.debug((Object)("original user principal: " + username));
        httpRequest.setAttribute(PENTAHO_ORIG_USER_PRINCIPAL, (Object)username);
        if (username != null && this.pattern != null) {
            Matcher m = this.pattern.matcher(username);
            logger.debug((Object)("pattern: " + this.pattern));
            logger.debug((Object)("input: " + username));
            if (m.find()) {
                logger.debug((Object)"pattern matches input; saving capture group");
                username = m.group(1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Windows PreAuthenticated J2EE principal: " + username));
        }
        return username;
    }

    public void setRegex(String regex) {
        this.pattern = StringUtils.isNotBlank((String)regex) ? Pattern.compile(regex) : null;
    }
}

