/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.messages.Messages;
import org.pentaho.platform.web.http.request.MultiReadHttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.util.Assert;

public class RequestParameterAuthenticationFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestParameterAuthenticationFilter.class);
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;
    private static final String DefaultUserNameParameter = "userid";
    private static final String DefaultPasswordParameter = "password";
    private String userNameParameter = "userid";
    private String passwordParameter = "password";
    private ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
    private boolean isRequestParameterAuthenticationEnabled;
    private boolean isRequestAuthenticationParameterLoaded = false;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)Messages.getInstance().getErrorString("RequestParameterAuthenticationFilter.ERROR_0001_AUTHMGR_REQUIRED"));
        Assert.notNull((Object)this.authenticationEntryPoint, (String)Messages.getInstance().getErrorString("RequestParameterAuthenticationFilter.ERROR_0002_AUTHM_ENTRYPT_REQUIRED"));
        Assert.hasText((String)this.userNameParameter, (String)Messages.getInstance().getString("RequestParameterAuthenticationFilter.ERROR_0003_USER_NAME_PARAMETER_MISSING"));
        Assert.hasText((String)this.passwordParameter, (String)Messages.getInstance().getString("RequestParameterAuthenticationFilter.ERROR_0004_PASSWORD_PARAMETER_MISSING"));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        IConfiguration config = this.systemConfig.getConfiguration("security");
        if (!this.isRequestAuthenticationParameterLoaded) {
            String strParameter = config.getProperties().getProperty("requestParameterAuthenticationEnabled");
            this.isRequestParameterAuthenticationEnabled = Boolean.valueOf(strParameter);
            this.isRequestAuthenticationParameterLoaded = true;
        }
        if (this.isRequestParameterAuthenticationEnabled) {
            if (!(request instanceof HttpServletRequest)) {
                throw new ServletException(Messages.getInstance().getErrorString("RequestParameterAuthenticationFilter.ERROR_0005_HTTP_SERVLET_REQUEST_REQUIRED"));
            }
            if (!(response instanceof HttpServletResponse)) {
                throw new ServletException(Messages.getInstance().getErrorString("RequestParameterAuthenticationFilter.ERROR_0006_HTTP_SERVLET_RESPONSE_REQUIRED"));
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            MultiReadHttpServletRequest wrapper = new MultiReadHttpServletRequest(httpRequest);
            String username = wrapper.getParameter(this.userNameParameter);
            String password = wrapper.getParameter(this.passwordParameter);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Messages.getInstance().getString("RequestParameterAuthenticationFilter.DEBUG_AUTH_USERID", new Object[]{username}));
            }
            if (username != null && password != null) {
                Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
                password = Encr.decryptPasswordOptionallyEncrypted((String)password);
                if (existingAuth == null || !existingAuth.getName().equals(username) || !existingAuth.isAuthenticated()) {
                    Authentication authResult;
                    UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
                    authRequest.setDetails((Object)new WebAuthenticationDetails(httpRequest));
                    try {
                        authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                    }
                    catch (AuthenticationException failed) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)Messages.getInstance().getString("RequestParameterAuthenticationFilter.DEBUG_AUTHENTICATION_REQUEST", new Object[]{username, failed.toString()}));
                        }
                        SecurityContextHolder.getContext().setAuthentication(null);
                        if (this.ignoreFailure) {
                            chain.doFilter((ServletRequest)wrapper, response);
                        } else {
                            this.authenticationEntryPoint.commence((HttpServletRequest)wrapper, (HttpServletResponse)response, failed);
                        }
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)Messages.getInstance().getString("RequestParameterAuthenticationFilter.DEBUG_AUTH_SUCCESS", new Object[]{authResult.toString()}));
                    }
                    SecurityContextHolder.getContext().setAuthentication(authResult);
                }
            }
            chain.doFilter((ServletRequest)wrapper, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public String getUserNameParameter() {
        return this.userNameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setUserNameParameter(String value) {
        this.userNameParameter = value;
    }

    public void setPasswordParameter(String value) {
        this.passwordParameter = value;
    }

    public ISystemConfig getSystemConfig() {
        return this.systemConfig;
    }

    public void setSystemConfig(ISystemConfig systemConfig) {
        this.systemConfig = systemConfig;
    }
}

