/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;

public class WebappRootForwardingFilter
implements Filter {
    private static final Pattern pentahoBasePattern = Pattern.compile("^/.*/WEBAPP_ROOT/");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String incomingUrl = httpRequest.getRequestURI();
        Matcher matcher = pentahoBasePattern.matcher(incomingUrl);
        if (matcher.find()) {
            String pentahoBasePrefix = matcher.group();
            String newUrl = incomingUrl.substring(pentahoBasePrefix.length());
            ((HttpServletResponse)response).sendRedirect(PentahoRequestContextHolder.getRequestContext().getContextPath() + newUrl);
        } else {
            chain.doFilter(request, response);
        }
    }
}

