/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.services.SystemService;

@Path(value="/users")
public class SystemUsersResource
extends AbstractJaxRSResource {
    @GET
    @Produces(value={"application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Response object containing an xml list of the users in the platform."), @ResponseCode(code=403, condition="Response due to the requesting user not having sufficient privileges."), @ResponseCode(code=500, condition="Internal server error occurs when the server cannot retrieve the list of users.")})
    public Response getUsers() throws Exception {
        try {
            return this.buildOkResponse(this.getSystemService().getUsers().asXML(), "application/xml");
        }
        catch (IllegalAccessException exception) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ServletException exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IOException exception) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected SystemService getSystemService() {
        return SystemService.getSystemService();
    }

    protected Response buildOkResponse(Object entity, String type) {
        return Response.ok((Object)entity).type(type).build();
    }
}

